package de.keksuccino.fancymenu.customization.background.backgrounds.animation;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.layout.editor.ChooseAnimationScreen;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

@Deprecated(forRemoval = true)
public class AnimationMenuBackgroundConfigScreen extends class_437 {

    protected class_437 parent;
    protected AnimationMenuBackground background;
    protected Consumer<AnimationMenuBackground> callback;

    protected ExtendedButton chooseAnimationButton;
    protected ExtendedButton toggleRestartOnLoadButton;
    protected ExtendedButton cancelButton;
    protected ExtendedButton doneButton;

    protected AnimationMenuBackgroundConfigScreen(@Nullable class_437 parent, @NotNull AnimationMenuBackground background, @NotNull Consumer<AnimationMenuBackground> callback) {

        super(Components.translatable("fancymenu.background.animation.configure"));

        this.parent = parent;
        this.background = background;
        this.callback = callback;

    }

    @Override
    protected void method_25426() {

        super.method_25426();

        this.chooseAnimationButton = new ExtendedButton(0, 0, 300, 20, Components.translatable("fancymenu.background.animation.configure.choose_animation"), (press) -> {
            ChooseAnimationScreen s = new ChooseAnimationScreen(this.background.animationName, (call) -> {
                if (call != null) {
                    this.background.animationName = call;
                }
                class_310.method_1551().method_1507(this);
            });
            class_310.method_1551().method_1507(s);
        });
        this.method_25429(this.chooseAnimationButton);
        UIBase.applyDefaultWidgetSkinTo(this.chooseAnimationButton);

        this.toggleRestartOnLoadButton = new ExtendedButton(0, 0, 300, 20, Components.literal(""), (press) -> {
            this.background.restartOnMenuLoad = !this.background.restartOnMenuLoad;
        }) {
            @Override
            public void method_25394(@NotNull class_4587 pose, int mouseX, int mouseY, float partial) {
                if (!AnimationMenuBackgroundConfigScreen.this.background.restartOnMenuLoad) {
                    this.method_25355(Components.translatable("fancymenu.background.animation.configure.restart_on_load.off"));
                } else {
                    this.method_25355(Components.translatable("fancymenu.background.animation.configure.restart_on_load.on"));
                }
                super.method_25394(pose, mouseX, mouseY, partial);
            }
        };
        this.method_25429(this.toggleRestartOnLoadButton);
        UIBase.applyDefaultWidgetSkinTo(this.toggleRestartOnLoadButton);

        this.doneButton = new ExtendedButton(0, 0, 145, 20, Components.translatable("fancymenu.guicomponents.done"), (press) -> {
            class_310.method_1551().method_1507(this.parent);
            this.callback.accept(this.background);
        }) {
            @Override
            public void method_25394(@NotNull class_4587 pose, int mouseX, int mouseY, float partial) {
                this.field_22763 = AnimationMenuBackgroundConfigScreen.this.background.animationName != null;
                if (!this.field_22763) {
                    TooltipHandler.INSTANCE.addWidgetTooltip(this, Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.background.animation.configure.no_animation_chosen")).setDefaultStyle(), false, true);
                }
                super.method_25394(pose, mouseX, mouseY, partial);
            }
        };
        this.method_25429(this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);

        this.cancelButton = new ExtendedButton(0, 0, 145, 20, Components.translatable("fancymenu.guicomponents.cancel"), (press) -> {
            this.method_25419();
        });
        this.method_25429(this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);

    }

    @Override
    public void method_25394(@NotNull class_4587 pose, int mouseX, int mouseY, float partial) {

        RenderSystem.enableBlend();

        method_25294(pose, 0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());

        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;

        class_5250 title = this.field_22785.method_27661().method_27692(class_124.field_1067);
        int titleWidth = this.field_22793.method_27525(title);
        this.field_22793.method_30883(pose, title, (float)centerX - ((float)titleWidth / 2F), 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt());

        this.chooseAnimationButton.field_22760 = centerX - (this.chooseAnimationButton.method_25368() / 2);
        this.chooseAnimationButton.field_22761 = centerY - 20 - 3;
        this.chooseAnimationButton.method_25394(pose, mouseX, mouseY, partial);

        this.toggleRestartOnLoadButton.field_22760 = centerX - (this.toggleRestartOnLoadButton.method_25368() / 2);
        this.toggleRestartOnLoadButton.field_22761 = centerY + 2;
        this.toggleRestartOnLoadButton.method_25394(pose, mouseX, mouseY, partial);

        this.doneButton.field_22760 = (this.field_22789 / 2) - this.doneButton.method_25368() - 5;
        this.doneButton.field_22761 = this.field_22790 - 40;
        this.doneButton.method_25394(pose, mouseX, mouseY, partial);

        this.cancelButton.field_22760 = (this.field_22789 / 2) + 5;
        this.cancelButton.field_22761 = this.field_22790 - 40;
        this.cancelButton.method_25394(pose, mouseX, mouseY, partial);

    }

    @Override
    public void method_25419() {
        class_310.method_1551().method_1507(this.parent);
        this.callback.accept(null);
    }

}
