package de.keksuccino.fancymenu.customization.background.backgrounds.panorama;

import de.keksuccino.fancymenu.customization.background.MenuBackgroundBuilder;
import de.keksuccino.fancymenu.customization.background.SerializedMenuBackground;
import de.keksuccino.fancymenu.customization.layout.editor.ChoosePanoramaScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class PanoramaMenuBackgroundBuilder extends MenuBackgroundBuilder<PanoramaMenuBackground> {

    public PanoramaMenuBackgroundBuilder() {
        super("panorama");
    }

    @Override
    public void buildNewOrEditInstance(class_437 currentScreen, @Nullable PanoramaMenuBackground backgroundToEdit, @NotNull Consumer<PanoramaMenuBackground> backgroundConsumer) {
        ChoosePanoramaScreen s = new ChoosePanoramaScreen((backgroundToEdit != null) ? backgroundToEdit.panoramaName : null, (call) -> {
            if (call != null) {
                if (backgroundToEdit != null) {
                    backgroundToEdit.panoramaName = call;
                    backgroundConsumer.accept(backgroundToEdit);
                } else {
                    PanoramaMenuBackground b = new PanoramaMenuBackground(this);
                    b.panoramaName = call;
                    backgroundConsumer.accept(b);
                }
            } else {
                backgroundConsumer.accept(backgroundToEdit);
            }
            class_310.method_1551().method_1507(currentScreen);
        });
        class_310.method_1551().method_1507(s);
    }

    @Override
    public PanoramaMenuBackground deserializeBackground(SerializedMenuBackground serializedMenuBackground) {

        PanoramaMenuBackground b = new PanoramaMenuBackground(this);

        b.panoramaName = serializedMenuBackground.getValue("panorama_name");

        return b;

    }

    @Override
    public SerializedMenuBackground serializedBackground(PanoramaMenuBackground background) {

        SerializedMenuBackground serialized = new SerializedMenuBackground();

        if (background.panoramaName != null) {
            serialized.putProperty("panorama_name", background.panoramaName);
        }

        return serialized;

    }

    @Override
    public @NotNull class_2561 getDisplayName() {
        return class_2561.method_43471("fancymenu.backgrounds.panorama");
    }

    @Override
    public @Nullable class_2561[] getDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.backgrounds.panorama.desc");
    }

}
