package de.keksuccino.fancymenu.customization.customgui;

import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.ModernScreen;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomGuiBaseScreen extends ModernScreen {

    private static final Logger LOGGER = LogManager.getLogger();
    private static final DrawableColor DARK_BACKGROUND = DrawableColor.BLACK;
    private static final float BACKGROUND_ALPHA = 0.4F;

    protected final CustomGui gui;
    protected final class_437 overrideScreen;
    protected final class_437 parentScreen;

    public CustomGuiBaseScreen(@NotNull CustomGui customGui, @Nullable class_437 parentScreen, @Nullable class_437 overrideScreen) {
        super(class_2561.method_43473());
        this.gui = customGui;
        this.overrideScreen = overrideScreen;
        this.parentScreen = parentScreen;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (this.gui.popupMode) {
            this.resizePopupMenuBackgroundScreen(class_310.method_1551(), this.field_22789, this.field_22790);
        }
    }

    protected void resizePopupMenuBackgroundScreen(class_310 minecraft, int width, int height) {
        try {
            if (this.parentScreen != null) {
                class_437 current = class_310.method_1551().field_1755;
                class_310.method_1551().field_1755 = this.parentScreen;
                this.parentScreen.method_25410(minecraft, width, height);
                class_310.method_1551().field_1755 = current;
            }
        } catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to resize popup menu background screen of Custom GUI!", ex);
        }
    }

    @Override
    public void method_25419() {
        class_310.method_1551().method_1507(this.parentScreen);
    }

    @Override
    public boolean method_25422() {
        return this.gui.allowEsc;
    }

    @Override
    public boolean method_25421() {
        return this.gui.pauseGame;
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {

        this._renderBackground(graphics, mouseX, mouseY, partial);

        super.render(graphics, mouseX, mouseY, partial);

        String title = PlaceholderParser.replacePlaceholders(this.getTitleString());
        class_2561 titleComp = LocalizationUtils.isLocalizationKey(title) ? class_2561.method_43471(title) : class_2561.method_43470(title);
        graphics.drawCenteredString(this.field_22793, titleComp, this.field_22789 / 2, 8, -1);

    }

    protected void _renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        boolean popup = this.gui.popupMode && (this.parentScreen != null);
        boolean popupOverlay = popup && this.gui.popupModeBackgroundOverlay;
        if (popup) {
            this.renderPopupMenuBackgroundScreen(graphics, mouseX, mouseY, partial);
        } else {
            if ((class_310.method_1551().field_1687 == null) || !this.gui.worldBackground) {
                this.method_25434(0);
                return;
            }
        }
        if (popupOverlay) {
            this.renderDarkBackgroundOverlay(graphics);
        }
        if (!popup) {
            this.renderBackground(graphics);
        }
    }

    protected void renderDarkBackgroundOverlay(@NotNull GuiGraphics graphics) {
        graphics.fill(0, 0, this.field_22789, this.field_22790, DARK_BACKGROUND.getColorIntWithAlpha(BACKGROUND_ALPHA));
    }

    protected void renderPopupMenuBackgroundScreen(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        RenderingUtils.setTooltipRenderingBlocked(true);
        class_437 current = class_310.method_1551().field_1755;
        CustomGui.isCurrentlyRenderingPopupBackgroundScreen = true;
        try {
            class_310.method_1551().field_1755 = this.parentScreen;
            // FancyMenu's render events get fired in renderWithTooltip, so they should fire here automatically
            this.parentScreen.method_25394(graphics.pose(), -500, -500, partial);
        } catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to render popup menu background screen of Custom GUI!", ex);
        }
        CustomGui.isCurrentlyRenderingPopupBackgroundScreen = false;
        class_310.method_1551().field_1755 = current;
        RenderingUtils.setTooltipRenderingBlocked(false);
    }

    @NotNull
    public String getTitleString() {
        return this.gui.title;
    }

    @NotNull
    public String getIdentifier() {
        return this.gui.identifier;
    }

    @Nullable
    public class_437 getOverriddenScreen() {
        return this.overrideScreen;
    }

    @NotNull
    public CustomGui getGuiMetadata() {
        return gui;
    }

    @Nullable
    public class_437 getParentScreen() {
        return this.parentScreen;
    }

}