package de.keksuccino.fancymenu.customization.element.elements.dragger;

import de.keksuccino.fancymenu.util.rendering.ui.widget.ModernAbstractWidget;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

public class DraggerWidget extends ModernAbstractWidget {

    @NotNull
    public DraggingCallback draggingCallback;
    @NotNull
    public MouseCallback mouseCallback;
    protected boolean leftMouseDown = false;

    public DraggerWidget(int x, int y, int width, int height, @NotNull DraggingCallback draggingCallback, @NotNull MouseCallback mouseCallback) {
        super(x, y, width, height, class_2561.method_43473());
        this.draggingCallback = draggingCallback;
        this.mouseCallback = mouseCallback;
    }

    @Override
    public void method_25359(@NotNull class_4587 guiGraphics, int i, int i1, float v) {
    }

    @Override
    public void method_37020(@NotNull class_6382 narrationElementOutput) {
    }

    @Override
    public void method_25354(@NotNull class_1144 soundManager) {
        //don't play click/down sound
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.canClick()) {
            this.leftMouseDown = true;
            this.mouseCallback.onClickOrRelease(mouseX, mouseY, false);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.leftMouseDown) {
            this.leftMouseDown = false;
            this.mouseCallback.onClickOrRelease(mouseX, mouseY, true);
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.leftMouseDown) {
            this.draggingCallback.onDrag(mouseX, mouseY, dragX, dragY);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    protected boolean canClick() {
        return (this.isHovered() && this.method_37303() && this.field_22764);
    }

    @FunctionalInterface
    public interface DraggingCallback {
        void onDrag(double mouseX, double mouseY, double dragX, double dragY);
    }

    @FunctionalInterface
    public interface MouseCallback {
        void onClickOrRelease(double mouseX, double mouseY, boolean released);
    }

}
