package de.keksuccino.fancymenu.customization.element.elements.playerentity.model.layers;

import com.mojang.serialization.Codec;
import de.keksuccino.fancymenu.customization.element.elements.playerentity.model.PlayerEntityElementRenderer;
import de.keksuccino.fancymenu.customization.element.elements.playerentity.model.PlayerEntityProperties;
import org.jetbrains.annotations.Nullable;

import java.util.function.IntFunction;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_584;

public class PlayerEntityShoulderParrotLayer extends PlayerEntityRenderLayer {

    private final class_584 model;
    public final PlayerEntityProperties properties;

    public PlayerEntityShoulderParrotLayer(PlayerEntityElementRenderer renderer, class_5599 modelSet, PlayerEntityProperties properties) {
        super(renderer);
        this.model = new class_584(modelSet.method_32072(class_5602.field_27619));
        this.properties = properties;
    }

    public void method_4199(class_4587 p_117307_, class_4597 p_117308_, int p_117309_, @Nullable class_1297 entity, float p_117311_, float p_117312_, float p_117313_, float p_117314_, float p_117315_, float p_117316_) {
        if (this.properties.hasParrotOnShoulder) {
            this.render(p_117307_, p_117308_, p_117309_, p_117311_, p_117312_, p_117315_, p_117316_, this.properties.parrotOnLeftShoulder);
        }
    }

    private void render(class_4587 p_117318_, class_4597 p_117319_, int p_117320_, float p_117322_, float p_117323_, float p_117324_, float p_117325_, boolean onLeftShoulder) {
        p_117318_.method_22903();
        p_117318_.method_22904(onLeftShoulder ? 0.4F : -0.4F, this.properties.isCrouching() ? -1.3F : -1.5F, 0.0F);
        Variant variant = Variant.byId(this.properties.shoulderParrotVariant);
        if (variant == null) variant = Variant.RED_BLUE;
        class_4588 vertexconsumer = p_117319_.getBuffer(this.model.method_23500(ParrotVariants.getVariantTexture(variant)));
        this.model.method_17106(p_117318_, vertexconsumer, p_117320_, class_4608.field_21444, p_117322_, p_117323_, p_117324_, p_117325_, this.properties.tickCount);
        p_117318_.method_22909();
    }

    public static class ParrotVariants {

        private static final class_2960 RED_BLUE = new class_2960("textures/entity/parrot/parrot_red_blue.png");
        private static final class_2960 BLUE = new class_2960("textures/entity/parrot/parrot_blue.png");
        private static final class_2960 GREEN = new class_2960("textures/entity/parrot/parrot_green.png");
        private static final class_2960 YELLOW_BLUE = new class_2960("textures/entity/parrot/parrot_yellow_blue.png");
        private static final class_2960 GREY = new class_2960("textures/entity/parrot/parrot_grey.png");

        public static class_2960 getVariantTexture(Variant variant) {
            return switch(variant) {
                case RED_BLUE -> RED_BLUE;
                case BLUE -> BLUE;
                case GREEN -> GREEN;
                case YELLOW_BLUE -> YELLOW_BLUE;
                case GRAY -> GREY;
            };
        }

    }

    public enum Variant {

        RED_BLUE(0),
        BLUE(1),
        GREEN(2),
        YELLOW_BLUE(3),
        GRAY(4);

        final int id;

        Variant(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        @Nullable
        public static Variant byId(int id) {
            for (Variant v : Variant.values()) {
                if (v.id == id) return v;
            }
            return null;
        }

    }

}