package de.keksuccino.fancymenu.customization.layout.editor;

import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.konkrete.math.MathUtils;
import org.jetbrains.annotations.NotNull;
import java.util.function.Consumer;
import net.minecraft.class_2583;
import net.minecraft.class_310;

public class AutoScalingScreen extends CellScreen {

    protected LayoutEditorScreen editor;
    protected Consumer<Boolean> callback;
    protected int autoScalingWidth;
    protected int autoScalingHeight;

    protected AutoScalingScreen(@NotNull LayoutEditorScreen editor, @NotNull Consumer<Boolean> callback) {
        super(Components.translatable("fancymenu.editor.auto_scaling.configure"));
        this.editor = editor;
        this.callback = callback;
        this.autoScalingWidth = class_310.method_1551().method_22683().method_4480();
        this.autoScalingHeight = class_310.method_1551().method_22683().method_4507();
    }

    @Override
    protected void initCells() {

        this.addSpacerCell(20);

        this.addLabelCell(Components.translatable("fancymenu.helper.editor.properties.autoscale.basesize.popup.desc.line1"));
        this.addLabelCell(Components.translatable("fancymenu.helper.editor.properties.autoscale.basesize.popup.desc.line2"));
        this.addLabelCell(Components.translatable("fancymenu.helper.editor.properties.autoscale.basesize.popup.desc.line3"));

        this.addDescriptionEndSeparatorCell();

        this.addLabelCell(Components.translatable("fancymenu.editor.auto_scaling.configure.width"));
        this.addTextInputCell(CharacterFilter.buildIntegerFiler(), false, false)
                .setText("" + this.autoScalingWidth)
                .setEditListener(s -> this.autoScalingWidth = MathUtils.isInteger(s) ? Integer.parseInt(s) : -1000);

        this.addCellGroupEndSpacerCell();

        this.addLabelCell(Components.translatable("fancymenu.editor.auto_scaling.configure.height"));
        this.addTextInputCell(CharacterFilter.buildIntegerFiler(), false, false)
                .setText("" + this.autoScalingHeight)
                .setEditListener(s -> this.autoScalingHeight = MathUtils.isInteger(s) ? Integer.parseInt(s) : -1000);

        this.addCellGroupEndSpacerCell();

        this.addLabelCell(Components.translatable("fancymenu.editor.auto_scaling.configure.current_screen_width", Components.literal("" + class_310.method_1551().method_22683().method_4480()).method_10862(class_2583.field_24360.method_10982(false))).method_10862(class_2583.field_24360.method_10982(true)));
        this.addLabelCell(Components.translatable("fancymenu.editor.auto_scaling.configure.current_screen_height", Components.literal("" + class_310.method_1551().method_22683().method_4507()).method_10862(class_2583.field_24360.method_10982(false))).method_10862(class_2583.field_24360.method_10982(true)));

        this.addSpacerCell(20);

    }

    @Override
    public boolean allowDone() {
        return (this.autoScalingWidth != -1000) && (this.autoScalingHeight != -1000);
    }

    @Override
    protected void onCancel() {
        this.callback.accept(false);
    }

    @Override
    protected void onDone() {
        this.editor.history.saveSnapshot();
        this.editor.layout.autoScalingWidth = this.autoScalingWidth;
        this.editor.layout.autoScalingHeight = this.autoScalingHeight;
        this.callback.accept(true);
    }

}
