package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.events.screen.ScreenCharTypedEvent;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import java.util.List;
import net.minecraft.class_2561;

public class OnCharTypedListener extends AbstractListener {

    private static final Logger LOGGER = LogManager.getLogger();

    protected Character lastTypedChar = null;

    public OnCharTypedListener() {

        super("keyboard_char_typed");

        // Register @EventListeners to the EventHandler
        EventHandler.INSTANCE.registerListenersOf(this);

    }

    @EventListener
    public void onCharTyped(ScreenCharTypedEvent e) {

        // Update cached typed char before notifying instances, so they can use the up-to-date char
        this.lastTypedChar = e.getCharacter();

        this.notifyAllInstances();

    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<CustomVariable> list) {

        // $$char
        list.add(new CustomVariable("char", () -> {
            if (this.lastTypedChar == null) return "ERROR";
            return this.lastTypedChar.toString();
        }));

    }

    @Override
    public @NotNull class_2561 getDisplayName() {
        return class_2561.method_43471("fancymenu.listeners.on_char_typed");
    }

    @Override
    public @NotNull List<class_2561> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_char_typed.desc"));
    }

}
