package de.keksuccino.fancymenu.customization.loadingrequirement.requirements.window;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.konkrete.math.MathUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_310;

public class IsWindowHeightBiggerThanRequirement extends LoadingRequirement {

    public IsWindowHeightBiggerThanRequirement() {
        super("fancymenu_loading_requirement_is_window_height_bigger_than");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        if (value != null) {
            value = value.replace(" ", "");
            if (MathUtils.isDouble(value)) {
                return class_310.method_1551().method_22683().method_4506() > (int)Double.parseDouble(value);
            }
        }
        return false;
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("fancymenu.requirements.windowheightbiggerthan");
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.windowheightbiggerthan.desc", "" + class_310.method_1551().method_22683().method_4489(), "" + class_310.method_1551().method_22683().method_4506()));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.requirements.categories.window");
    }

    @Override
    public String getValueDisplayName() {
        return class_1074.method_4662("fancymenu.requirements.windowheightbiggerthan.value_name");
    }

    @Override
    public String getValuePreset() {
        return "1080";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

}
