package de.keksuccino.fancymenu.customization.loadingrequirement.requirements.world.player;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_2170;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import java.util.Arrays;
import java.util.List;

public class HasPlayerPermissionLevelRequirement extends LoadingRequirement {

    private static final Logger LOGGER = LogManager.getLogger();

    public HasPlayerPermissionLevelRequirement() {
        super("fancymenu_loading_requirement_has_player_permission_level");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        if (value == null) {
            return false;
        }
        String trimmed = value.trim();
        if (trimmed.isEmpty()) {
            return false;
        }
        int requiredLevel;
        try {
            requiredLevel = Integer.parseInt(trimmed);
        } catch (NumberFormatException ex) {
            LOGGER.warn("[FANCYMENU] Invalid permission level '{}' provided to '{}' requirement!", trimmed, this.getIdentifier());
            return false;
        }
        if (requiredLevel < class_2170.field_31837) {
            requiredLevel = class_2170.field_31837;
        }
        try {
            class_638 level = class_310.method_1551().field_1687;
            class_746 player = class_310.method_1551().field_1724;
            if ((level != null) && (player != null)) {
                return player.method_5687(requiredLevel);
            }
        } catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to handle '" + this.getIdentifier() + "' loading requirement!", ex);
        }
        return false;
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("fancymenu.requirements.world.has_player_permission_level");
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.world.has_player_permission_level.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.requirements.categories.world");
    }

    @Override
    public String getValueDisplayName() {
        return class_1074.method_4662("fancymenu.requirements.world.has_player_permission_level.value_name");
    }

    @Override
    public String getValuePreset() {
        return String.valueOf(class_2170.field_31839);
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }
}
