package de.keksuccino.fancymenu.customization.placeholder.placeholders.scoreboard;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class ScoreboardDisplaySlotPlaceholder extends Placeholder {

    public ScoreboardDisplaySlotPlaceholder() {
        super("scoreboard_display_slot");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        class_638 level = class_310.method_1551().field_1687;
        String slotName = dps.values.get("slot");
        
        if ((level != null) && (slotName != null)) {
            class_269 scoreboard = level.method_8428();
            int slot = class_269.method_1192(slotName);
            
            if (slot != -1) {
                class_266 objective = scoreboard.method_1189(slot);
                if (objective != null) {
                    return objective.method_1113();
                }
            }
        }
        return "";
    }

    @Override
    public @Nullable List<String> getValueNames() {
        return List.of("slot");
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("fancymenu.placeholders.scoreboard.display_slot");
    }

    @Override
    public @Nullable List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.scoreboard.display_slot.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.placeholders.categories.scoreboard");
    }

    @Override
    public @NotNull DeserializedPlaceholderString getDefaultPlaceholderString() {
        HashMap<String, String> values = new LinkedHashMap<>();
        values.put("slot", "sidebar");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}
