package de.keksuccino.fancymenu.customization.placeholder.placeholders.scoreboard;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_638;

public class ScoreboardObjectivesListPlaceholder extends Placeholder {

    public ScoreboardObjectivesListPlaceholder() {
        super("scoreboard_objectives_list");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {

        class_634 connection = class_310.method_1551().method_1562();

        class_638 level = (connection != null) ? connection.method_2890() : null;
        class_269 scoreboard = (level != null) ? level.method_8428(): null;
        String separator = dps.values.get("separator");
        if (separator == null) separator = ", ";

        if (scoreboard != null) {
            Collection<class_266> objectives = scoreboard.method_1151();
            return objectives.stream()
                    .map(class_266::method_1113)
                    .collect(Collectors.joining(separator));
        }

        return "";

    }

    @Override
    public @Nullable List<String> getValueNames() {
        return List.of("separator");
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("fancymenu.placeholders.scoreboard.objectives_list");
    }

    @Override
    public @Nullable List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.scoreboard.objectives_list.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.placeholders.categories.scoreboard");
    }

    @Override
    public @NotNull DeserializedPlaceholderString getDefaultPlaceholderString() {
        HashMap<String, String> values = new LinkedHashMap<>();
        values.put("separator", ", ");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}
