package de.keksuccino.fancymenu.customization.placeholder.placeholders.world;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinBossHealthOverlay;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.MathUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_345;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class CurrentBossHealthPlaceholder extends Placeholder {

    public CurrentBossHealthPlaceholder() {
        super("current_boss_health");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        class_746 player = class_310.method_1551().field_1724;
        class_638 level = class_310.method_1551().field_1687;
        String indexString = dps.values.get("boss_index");
        if ((player != null) && (level != null) && MathUtils.isInteger(indexString)) {
            int index = Integer.parseInt(indexString);
            Map<UUID, class_345> bosses = ((IMixinBossHealthOverlay)class_310.method_1551().field_1705.method_1740()).get_events_FancyMenu(); // this is a linked hash map, so indexes should work fine
            if (bosses.size() >= (index + 1)) {
                int i = 0;
                for (Map.Entry<UUID, class_345> m : bosses.entrySet()) {
                    if (index == i) {
                        int progress = (int) (m.getValue().method_5412() * 100.0F);
                        return "" + progress;
                    }
                    i++;
                }
            }
        }
        return "0";
    }

    @Override
    public @Nullable List<String> getValueNames() {
        return List.of("boss_index");
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("fancymenu.placeholders.world.current_boss_health");
    }

    @Override
    public @Nullable List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.world.current_boss_health.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.placeholders.categories.world");
    }

    @Override
    public @NotNull DeserializedPlaceholderString getDefaultPlaceholderString() {
        HashMap<String, String> values = new HashMap<>();
        values.put("boss_index", "0");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }

}
