package de.keksuccino.fancymenu.customization.placeholder.placeholders.world;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_642;
import net.minecraft.class_746;

public class CurrentServerIpPlaceholder extends Placeholder {

    public CurrentServerIpPlaceholder() {
        super("current_server_ip");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @SuppressWarnings("all")
    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        class_746 player = class_310.method_1551().field_1724;
        class_638 level = class_310.method_1551().field_1687;
        class_642 data = class_310.method_1551().method_1558();
        if ((player != null) && (level != null) && (player.field_3944 != null) && (data != null) && (data.field_3761 != null)) {
            return data.field_3761;
        }
        return "";
    }

    @Override
    public @Nullable List<String> getValueNames() {
        return null;
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("fancymenu.placeholders.world.current_server_ip");
    }

    @Override
    public @Nullable List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.world.current_server_ip.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.placeholders.categories.world");
    }

    @Override
    public @NotNull DeserializedPlaceholderString getDefaultPlaceholderString() {
        return new DeserializedPlaceholderString(this.getIdentifier(), null, "");
    }

}
