package de.keksuccino.fancymenu.customization.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import de.keksuccino.fancymenu.events.screen.RenderScreenEvent;
import de.keksuccino.fancymenu.events.widget.RenderWidgetBackgroundEvent;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_3532;

@SuppressWarnings("unused")
public class VanillaButtonHandler {

    private static final Map<class_339, class_2960> BACKGROUND_TEXTURES = new HashMap<>();
    private static final Map<class_339, VanillaBackgroundAnimation> BACKGROUND_ANIMATIONS = new HashMap<>();

    public static void init() {
        EventHandler.INSTANCE.registerListenersOf(new VanillaButtonHandler());
    }

    public static void setRenderTickBackgroundTexture(class_339 widget, class_2960 background) {
        if (background != null) {
            BACKGROUND_TEXTURES.put(widget, background);
        } else {
            BACKGROUND_TEXTURES.remove(widget);
        }
    }

    public static void setRenderTickBackgroundAnimation(class_339 widget, IAnimationRenderer background, boolean loop, float opacity) {
        if (background != null) {
            BACKGROUND_ANIMATIONS.put(widget, new VanillaBackgroundAnimation(background, loop, opacity));
        } else {
            BACKGROUND_ANIMATIONS.remove(widget);
        }
    }

    @EventListener
    public void onRenderButtonBackgroundPre(RenderWidgetBackgroundEvent.Pre e) {

        class_339 w = e.getWidget();
        class_2960 backgroundTexture = BACKGROUND_TEXTURES.get(w);
        VanillaBackgroundAnimation backgroundAnimation = BACKGROUND_ANIMATIONS.get(w);

        RenderSystem.enableBlend();

        if (backgroundTexture != null) {
            RenderUtils.bindTexture(backgroundTexture);
            class_332.method_25290(e.getPoseStack(), w.field_22760, w.field_22761, 0.0F, 0.0F, w.method_25368(), w.method_25364(), w.method_25368(), w.method_25364());
        }
        if ((backgroundTexture == null) && (backgroundAnimation != null)) {
            boolean loop = backgroundAnimation.animationRenderer.isGettingLooped();
            int aw = backgroundAnimation.animationRenderer.getWidth();
            int ah = backgroundAnimation.animationRenderer.getHeight();
            int ax = backgroundAnimation.animationRenderer.getPosX();
            int ay = backgroundAnimation.animationRenderer.getPosY();
            backgroundAnimation.animationRenderer.setWidth(w.method_25368());
            backgroundAnimation.animationRenderer.setHeight(w.method_25364());
            backgroundAnimation.animationRenderer.setPosX(w.field_22760);
            backgroundAnimation.animationRenderer.setPosY(w.field_22761);
            backgroundAnimation.animationRenderer.setOpacity(backgroundAnimation.opacity);
            backgroundAnimation.animationRenderer.setLooped(backgroundAnimation.loop);
            backgroundAnimation.animationRenderer.render(e.getPoseStack());
            backgroundAnimation.animationRenderer.setWidth(aw);
            backgroundAnimation.animationRenderer.setHeight(ah);
            backgroundAnimation.animationRenderer.setPosX(ax);
            backgroundAnimation.animationRenderer.setPosY(ay);
            backgroundAnimation.animationRenderer.setOpacity(1.0F);
            backgroundAnimation.animationRenderer.setLooped(loop);
        }

        if ((backgroundTexture != null) || (backgroundAnimation != null)) {
            if (w instanceof class_344) {
                class_2561 msg = w.method_25369();
                int j = w.field_22763 ? 16777215 : 10526880;
                class_332.method_27534(e.getPoseStack(), class_310.method_1551().field_1772, msg, w.field_22760 + w.method_25368() / 2, w.field_22761 + (w.method_25364() - 8) / 2, j | class_3532.method_15386(e.getAlpha() * 255.0F) << 24);
            }
            e.setCanceled(true);
        }

    }

    @EventListener(priority = -100)
    public void onRenderScreenPost(RenderScreenEvent.Post e) {
        BACKGROUND_TEXTURES.clear();
        BACKGROUND_ANIMATIONS.clear();
    }

    protected static class VanillaBackgroundAnimation {

        protected IAnimationRenderer animationRenderer;
        protected boolean loop;
        protected float opacity;

        protected VanillaBackgroundAnimation(IAnimationRenderer animationRenderer, boolean loop, float opacity) {
            this.animationRenderer = animationRenderer;
            this.loop = loop;
            this.opacity = opacity;
        }

    }

}
