package de.keksuccino.fancymenu.events;

import de.keksuccino.fancymenu.util.event.acara.EventBase;
import net.minecraft.class_437;

/**
 * Fired when soft-reloading the <b>current</b> menu.<br>
 * Not the same as {@link ModReloadEvent}, which is fired when completely reloading the system and <b>all</b> menus, not just the current one.
 */
public class ScreenReloadEvent extends EventBase {

    private final class_437 screen;

    public ScreenReloadEvent(class_437 screen) {
        this.screen = screen;
    }

    public class_437 getScreen() {
        return screen;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

}
