package de.keksuccino.fancymenu.events.screen;

import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.fancymenu.util.event.acara.EventBase;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6379;

public class AfterScreenRenderingEvent extends EventBase {

    private final class_437 screen;
    private final GuiGraphics graphics;
    private final int mouseX;
    private final int mouseY;
    private final float partial;

    public AfterScreenRenderingEvent(@NotNull class_437 screen, @NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.screen = Objects.requireNonNull(screen);
        this.graphics = Objects.requireNonNull(graphics);
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.partial = partial;
    }

    public class_437 getScreen() {
        return this.screen;
    }

    @NotNull
    public GuiGraphics getGraphics() {
        return graphics;
    }

    @NotNull
    public class_4587 getPoseStack() {
        return graphics.pose();
    }

    public int getMouseX() {
        return mouseX;
    }

    public int getMouseY() {
        return mouseY;
    }

    public float getPartial() {
        return partial;
    }

    public <T extends class_364 & class_6379> void addWidget(T widget) {
        this.getWidgets().add(widget);
        this.getNarratables().add(widget);
    }

    public <T extends class_364 & class_6379 & class_4068> void addRenderableWidget(T widget) {
        this.addWidget(widget);
        this.getRenderables().add(widget);
    }

    public List<class_364> getWidgets() {
        return ((IMixinScreen)this.getScreen()).getChildrenFancyMenu();
    }

    public List<class_4068> getRenderables() {
        return ((IMixinScreen)this.getScreen()).getRenderablesFancyMenu();
    }

    public List<class_6379> getNarratables() {
        return ((IMixinScreen)this.getScreen()).getNarratablesFancyMenu();
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

}
