package de.keksuccino.fancymenu.events.screen;

import de.keksuccino.fancymenu.util.event.acara.EventBase;
import org.jetbrains.annotations.NotNull;
import java.util.Objects;
import net.minecraft.class_310;
import net.minecraft.class_437;

/**
 * Gets fired when a {@link class_437} gets opened via {@link class_310#method_1507(class_437)}.<br>
 * The {@link class_437} got initialized already at the time this event gets fired.<br><br>
 *
 * If there was a {@link class_437} active before, then it got closed already at the time this event gets fired.
 */
public class OpenScreenPostInitEvent extends EventBase {

    private final class_437 screen;

    public OpenScreenPostInitEvent(@NotNull class_437 screen) {
        this.screen = Objects.requireNonNull(screen);
    }

    @NotNull
    public class_437 getScreen() {
        return this.screen;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

}
