package de.keksuccino.fancymenu.mixin.mixins.common.client;

import de.keksuccino.fancymenu.events.widget.RenderGuiListHeaderFooterEvent;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import net.minecraft.class_350;
import net.minecraft.class_4587;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.At.Shift;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import de.keksuccino.fancymenu.events.widget.RenderGuiListBackgroundEvent;

@Mixin(value = class_350.class)
public abstract class MixinAbstractSelectionList {

	@Shadow private boolean renderTopAndBottom;

	@Unique private boolean shouldFireRenderHeaderFooterEventsFancyMenu;

	@Inject(method = "render(Lcom/mojang/blaze3d/vertex/PoseStack;IIF)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/components/AbstractSelectionList;isMouseOver(DD)Z", shift = Shift.AFTER))
	private void beforeRenderListBackgroundFancyMenu(class_4587 matrix, int mouseX, int mouseY, float partial, CallbackInfo info) {
		RenderGuiListBackgroundEvent.Pre e = new RenderGuiListBackgroundEvent.Pre(matrix, (class_350) ((Object)this));
		EventHandler.INSTANCE.postEvent(e);
	}
	
	@Inject(method = "render(Lcom/mojang/blaze3d/vertex/PoseStack;IIF)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/components/AbstractSelectionList;getRowLeft()I"))
	private void afterRenderListBackgroundFancyMenu(class_4587 matrix, int mouseX, int mouseY, float partial, CallbackInfo info) {
		RenderGuiListBackgroundEvent.Post e = new RenderGuiListBackgroundEvent.Post(matrix, (class_350) ((Object)this));
		EventHandler.INSTANCE.postEvent(e);
	}

	@Inject(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/components/AbstractSelectionList;renderList(Lcom/mojang/blaze3d/vertex/PoseStack;IIF)V", shift = Shift.AFTER))
	private void beforeRenderListHeaderFooterFancyMenu(class_4587 pose, int $$1, int $$2, float $$3, CallbackInfo info) {
		this.shouldFireRenderHeaderFooterEventsFancyMenu = this.renderTopAndBottom;
		if (this.shouldFireRenderHeaderFooterEventsFancyMenu) {
			RenderGuiListHeaderFooterEvent.Pre e = new RenderGuiListHeaderFooterEvent.Pre(pose, (class_350) ((Object)this));
			EventHandler.INSTANCE.postEvent(e);
			if (e.isCanceled()) this.renderTopAndBottom = false;
		}
	}

	@Inject(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/components/AbstractSelectionList;getMaxScroll()I"))
	private void afterRenderListHeaderFooterFancyMenu(class_4587 pose, int $$1, int $$2, float $$3, CallbackInfo info) {
		if (this.shouldFireRenderHeaderFooterEventsFancyMenu) {
			RenderGuiListHeaderFooterEvent.Post e = new RenderGuiListHeaderFooterEvent.Post(pose, (class_350) ((Object)this));
			EventHandler.INSTANCE.postEvent(e);
			this.renderTopAndBottom = true;
		}
	}
	
}
