package de.keksuccino.fancymenu.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.WrapWithCondition;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableWidget;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@SuppressWarnings("unused")
@Mixin(class_344.class)
public abstract class MixinImageButton extends class_332 {

	@Unique private float[] cachedShaderColor_FancyMenu;

	@WrapWithCondition(method = "renderButton", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/components/ImageButton;blit(Lcom/mojang/blaze3d/vertex/PoseStack;IIFFIIII)V"))
	private boolean wrapRenderTextureFancyMenu(class_4587 pose, int i1, int i2, float v3, float v4, int i5, int i6, int i7, int i8) {

		GuiGraphics graphics = GuiGraphics.currentGraphics();

		class_344 button = (class_344)((Object)this);
		CustomizableWidget customizable = ((CustomizableWidget)this);

		//Render custom background if present
		boolean renderVanilla = ((CustomizableWidget)this).renderCustomBackgroundFancyMenu(button, graphics, button.field_22760, button.field_22761, button.method_25368(), button.method_25364());

		//Render custom labels if present
		if (!renderVanilla && (((customizable.getCustomLabelFancyMenu() != null) && !button.method_25367()) || ((customizable.getHoverLabelFancyMenu() != null) && button.method_25367()))) {
			int labelColor = button.field_22763 ? 16777215 : 10526880;
			graphics.drawCenteredString(class_310.method_1551().field_1772, button.method_25369(), button.field_22760 + button.method_25368() / 2, button.field_22761 + (button.method_25364() - 8) / 2, labelColor | class_3532.method_15386(((IMixinAbstractWidget)button).getAlphaFancyMenu() * 255.0F) << 24);
		}

		cachedShaderColor_FancyMenu = RenderSystem.getShaderColor();
		if (cachedShaderColor_FancyMenu.length < 4) cachedShaderColor_FancyMenu = new float[] { 1.0F, 1.0F, 1.0F, 1.0F };

		RenderSystem.enableBlend();

		//Fix missing alpha handling for ImageButtons (Vanilla bug)
		graphics.setColor(cachedShaderColor_FancyMenu[0], cachedShaderColor_FancyMenu[1], cachedShaderColor_FancyMenu[2], ((IMixinAbstractWidget)button).getAlphaFancyMenu());

		//If it should render the Vanilla background
		return renderVanilla;

	}

	@Inject(method = "renderButton", at = @At("RETURN"))
	private void afterRenderWidgetFancyMenu(class_4587 $$0, int $$1, int $$2, float $$3, CallbackInfo info) {
		//Reset shader color after alpha handling
		if (cachedShaderColor_FancyMenu == null) cachedShaderColor_FancyMenu = new float[] { 1.0F, 1.0F, 1.0F, 1.0F };
		RenderSystem.setShaderColor(cachedShaderColor_FancyMenu[0], cachedShaderColor_FancyMenu[1], cachedShaderColor_FancyMenu[2], cachedShaderColor_FancyMenu[3]);
		cachedShaderColor_FancyMenu = null;
	}
	
}
