package de.keksuccino.fancymenu.mixin.mixins.common.client;

import de.keksuccino.fancymenu.customization.gameintro.GameIntroOverlay;
import de.keksuccino.fancymenu.customization.listener.listeners.Listeners;
import de.keksuccino.fancymenu.events.screen.ScreenMouseMoveEvent;
import de.keksuccino.fancymenu.events.screen.ScreenMouseScrollEvent;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import net.minecraft.class_310;
import net.minecraft.class_312;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_312.class)
public class MixinMouseHandler {

    @Shadow private double xpos;
    @Shadow private double ypos;
    @Shadow private double accumulatedDX;
    @Shadow private double accumulatedDY;

    private final class_310 mc_FancyMenu = class_310.method_1551();

    @Inject(method = "onScroll", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/Screen;mouseScrolled(DDD)Z"), cancellable = true)
    private void beforeMouseScrollScreenFancyMenu(long $$0, double $$1, double $$2, CallbackInfo info) {
        double offset = $$2;
        if (class_310.field_1703 && $$2 == 0) {
            offset = $$1;
        }
        double scrollDelta = (this.mc_FancyMenu.field_1690.method_42439().method_41753() ? Math.signum(offset) : offset) * this.mc_FancyMenu.field_1690.method_41806().method_41753();
        double mX = this.xpos * (double)this.mc_FancyMenu.method_22683().method_4486() / (double)this.mc_FancyMenu.method_22683().method_4480();
        double mY = this.ypos * (double)this.mc_FancyMenu.method_22683().method_4502() / (double)this.mc_FancyMenu.method_22683().method_4507();
        ScreenMouseScrollEvent.Pre e = new ScreenMouseScrollEvent.Pre(mc_FancyMenu.field_1755, mX, mY, scrollDelta);
        EventHandler.INSTANCE.postEvent(e);
        if (e.isCanceled()) {
            info.cancel();
        }
    }

    @Inject(method = "onScroll", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/Screen;mouseScrolled(DDD)Z", shift = At.Shift.AFTER))
    private void afterMouseScrollScreenFancyMenu(long $$0, double $$1, double $$2, CallbackInfo info) {
        double offset = $$2;
        if (class_310.field_1703 && $$2 == 0) {
            offset = $$1;
        }
        double scrollDelta = (this.mc_FancyMenu.field_1690.method_42439().method_41753() ? Math.signum(offset) : offset) * this.mc_FancyMenu.field_1690.method_41806().method_41753();
        double mX = this.xpos * (double)this.mc_FancyMenu.method_22683().method_4486() / (double)this.mc_FancyMenu.method_22683().method_4480();
        double mY = this.ypos * (double)this.mc_FancyMenu.method_22683().method_4502() / (double)this.mc_FancyMenu.method_22683().method_4507();
        ScreenMouseScrollEvent.Post e = new ScreenMouseScrollEvent.Post(mc_FancyMenu.field_1755, mX, mY, scrollDelta);
        EventHandler.INSTANCE.postEvent(e);
    }

    @Inject(method = "onPress", at = @At(value = "HEAD"))
    private void headOnPressFancyMenu(long window, int button, int action, int modifiers, CallbackInfo info) {
        if (window == class_310.method_1551().method_22683().method_4490()) {
            boolean clicked = action == GLFW.GLFW_PRESS;
            if (clicked && (class_310.method_1551().method_18506() instanceof GameIntroOverlay o)) o.mouseClicked(button);
        }
    }

    /**
     * @reason Fire FancyMenu's mouse button listeners after vanilla processing so they run once per press/release.
     */
    @Inject(method = "onPress", at = @At("RETURN"))
    private void triggerMouseButtonListeners_FancyMenu(long window, int button, int action, int modifiers, CallbackInfo info) {
        if (window != this.mc_FancyMenu.method_22683().method_4490()) {
            return;
        }

        double guiWidth = (double)this.mc_FancyMenu.method_22683().method_4486();
        double guiHeight = (double)this.mc_FancyMenu.method_22683().method_4502();
        double screenWidth = (double)this.mc_FancyMenu.method_22683().method_4480();
        double screenHeight = (double)this.mc_FancyMenu.method_22683().method_4507();
        double mouseX = this.xpos * guiWidth / screenWidth;
        double mouseY = this.ypos * guiHeight / screenHeight;

        if (action == GLFW.GLFW_PRESS) {
            Listeners.ON_MOUSE_BUTTON_CLICKED.onMouseButtonClicked(button, mouseX, mouseY);
        } else if (action == GLFW.GLFW_RELEASE) {
            Listeners.ON_MOUSE_BUTTON_RELEASED.onMouseButtonReleased(button, mouseX, mouseY);
        }
    }

    @Inject(method = "onMove", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/Screen;wrapScreenError(Ljava/lang/Runnable;Ljava/lang/String;Ljava/lang/String;)V"))
    private void before_Screen_mouseMoved_FancyMenu(CallbackInfo info) {
        double guiWidth = (double)this.mc_FancyMenu.method_22683().method_4486();
        double guiHeight = (double)this.mc_FancyMenu.method_22683().method_4502();
        double screenWidth = (double)this.mc_FancyMenu.method_22683().method_4480();
        double screenHeight = (double)this.mc_FancyMenu.method_22683().method_4507();
        double mouseX = this.xpos * guiWidth / screenWidth;
        double mouseY = this.ypos * guiHeight / screenHeight;
        double deltaX = this.accumulatedDX * guiWidth / screenWidth;
        double deltaY = this.accumulatedDY * guiHeight / screenHeight;
        EventHandler.INSTANCE.postEvent(new ScreenMouseMoveEvent(this.mc_FancyMenu.field_1755, mouseX, mouseY, deltaX, deltaY));
    }

}
