package de.keksuccino.fancymenu.mixin.mixins.common.client;

import de.keksuccino.fancymenu.util.MinecraftResourceReloadObserver;
import net.minecraft.class_310;
import net.minecraft.class_6360;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_6360.class)
public class MixinResourceLoadStateTracker {

    @Inject(method = "startReload", at = @At("HEAD"))
    private void beforeStartReloadFancyMenu(CallbackInfo info) {
        if (((IMixinMinecraft)class_310.method_1551()).getReloadStateTrackerFancyMenu() == ((Object)this)) {
            MinecraftResourceReloadObserver.getReloadListeners().forEach(reloadActionConsumer -> reloadActionConsumer.accept(MinecraftResourceReloadObserver.ReloadAction.STARTING));
        }
    }

    @Inject(method = "finishReload", at = @At("RETURN"))
    private void afterFinishReloadFancyMenu(CallbackInfo info) {
        if (((IMixinMinecraft)class_310.method_1551()).getReloadStateTrackerFancyMenu() == ((Object)this)) {
            MinecraftResourceReloadObserver.getReloadListeners().forEach(reloadActionConsumer -> reloadActionConsumer.accept(MinecraftResourceReloadObserver.ReloadAction.FINISHED));
        }
    }

}
