package de.keksuccino.fancymenu.networking;

import net.minecraft.class_124;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Packet {

    private static final Logger LOGGER = LogManager.getLogger();

    /**
     * @param sender The sender of the packet in case it was sent from client to server. This is NULL if the packet was sent by the server to the client!
     */
    public abstract boolean processPacket(@Nullable class_3222 sender);

    public void sendChatFeedback(@NotNull class_5250 message, boolean failure) {
        try {
            if ((class_310.method_1551().field_1724 != null) && (class_310.method_1551().field_1687 != null)) {
                if (failure) message = message.method_27692(class_124.field_1061);
                class_310.method_1551().field_1724.method_43496(message);
            }
        } catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to send packet chat feedback!", ex);
        }
    }

}
