package de.keksuccino.fancymenu.util.cycle;

import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.enums.LocalizedEnum;
import org.jetbrains.annotations.NotNull;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

@SuppressWarnings("unused")
public class LocalizedEnumValueCycle<E extends LocalizedEnum<?>> extends ValueCycle<E> implements ILocalizedValueCycle<E> {

    protected String cycleLocalizationKey;
    protected ConsumingSupplier<E, class_2583> cycleStyle = consumes -> class_2583.field_24360;

    @SafeVarargs
    public static <E extends LocalizedEnum<?>> LocalizedEnumValueCycle<E> ofArray(@NotNull String cycleLocalizationKey, @NotNull E... values) {
        Objects.requireNonNull(values);
        List<E> valueList = Arrays.asList(values);
        if (valueList.size() < 2) {
            throw new InvalidParameterException("Failed to create LocalizedValueCycle! Value list size too small (<2)!");
        }
        LocalizedEnumValueCycle<E> valueCycle = new LocalizedEnumValueCycle<>(cycleLocalizationKey);
        valueCycle.values.addAll(valueList);
        return valueCycle;
    }

    @SuppressWarnings("all")
    public static <E extends LocalizedEnum<?>> LocalizedEnumValueCycle<E> ofList(@NotNull String cycleLocalizationKey, @NotNull List<E> values) {
        return ofArray(cycleLocalizationKey, (E[])values.toArray(new Object[0]));
    }

    protected LocalizedEnumValueCycle(String cycleLocalizationKey) {
        this.cycleLocalizationKey = cycleLocalizationKey;
    }

    @NotNull
    public String getCycleLocalizationKey() {
        return this.cycleLocalizationKey;
    }

    public class_5250 getCycleComponent() {
        return class_2561.method_43469(this.getCycleLocalizationKey(), this.getCurrentValueComponent()).method_27696(this.cycleStyle.get(this.current()));
    }

    public class_5250 getCurrentValueComponent() {
        return this.current().getValueComponent();
    }

    public LocalizedEnumValueCycle<E> setCycleComponentStyleSupplier(@NotNull ConsumingSupplier<E, class_2583> supplier) {
        this.cycleStyle = supplier;
        return this;
    }

    @Override
    public LocalizedEnumValueCycle<E> addCycleListener(@NotNull Consumer<E> listener) {
        return (LocalizedEnumValueCycle<E>) super.addCycleListener(listener);
    }

}
