package de.keksuccino.fancymenu.util.enums;

import de.keksuccino.fancymenu.util.cycle.LocalizedGenericValueCycle;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @param <E> The enum type.
 */
public interface LocalizedCycleEnum<E> extends LocalizedEnum<E> {

    @NotNull
    default class_5250 getCycleComponent() {
        return class_2561.method_43469(this.getLocalizationKeyBase(), this.getValueComponent()).method_27696(this.getCycleComponentStyle());
    }

    @NotNull
    default class_2583 getCycleComponentStyle() {
        return class_2583.field_24360;
    }

    @NotNull
    default LocalizedGenericValueCycle<E> cycle(@Nullable E selected) {
        LocalizedGenericValueCycle<E> cycle = LocalizedGenericValueCycle.of(this.getLocalizationKeyBase(), this.getValues());
        cycle.setCycleComponentStyleSupplier(consumes -> this.getCycleComponentStyle());
        cycle.setValueComponentStyleSupplier(consumes -> this.getValueComponentStyle());
        cycle.setValueNameSupplier(consumes -> {
            if (consumes instanceof LocalizedCycleEnum<?> e) return class_1074.method_4662(e.getValueLocalizationKey());
            return consumes.toString();
        });
        if (selected != null) cycle.setCurrentValue(selected);
        return cycle;
    }

    default LocalizedGenericValueCycle<E> cycle() {
        return cycle(this.getByNameInternal(this.getName()));
    }

}
