package de.keksuccino.fancymenu.util.rendering.ui.screen.queueable;

import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.ModernScreen;
import org.jetbrains.annotations.NotNull;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class QueueableScreen extends ModernScreen {

    private volatile Consumer<QueueableScreen> closeCallback;

    protected QueueableScreen(@NotNull class_2561 title) {
        super(title);
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        assertQueueableSetUpCorrectly();
        this.renderBackground(graphics);
        super.render(graphics, mouseX, mouseY, partial);
    }

    @Override
    protected void method_25426() {
        assertQueueableSetUpCorrectly();
        super.method_25426();
    }

    @Override
    public void method_25410(@NotNull class_310 mc, int width, int height) {
        assertQueueableSetUpCorrectly();
        super.method_25410(mc, width, height);
    }

    @Override
    protected void method_41843() {
        assertQueueableSetUpCorrectly();
        super.method_41843();
    }

    @Override
    public void method_25419() {
        this.notifyHandlerOnClose();
    }

    public void setCloseCallback(@NotNull Consumer<QueueableScreen> closeCallback) {
        this.closeCallback = closeCallback;
        assertQueueableSetUpCorrectly();
    }

    protected void notifyHandlerOnClose() {
        assertQueueableSetUpCorrectly();
        this.closeCallback.accept(this);
    }

    public void assertQueueableSetUpCorrectly() {
        if (this.closeCallback == null) throw new RuntimeException("Close callback was NULL! QueueableScreens need to get opened via QueueableScreenHandler!");
    }

}
