package de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry;

import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;

public class TextScrollAreaEntry extends ScrollAreaEntry {

    private static final Logger LOGGER = LogManager.getLogger();

    protected class_2561 text;
    protected int textWidth;
    public class_327 font = class_310.method_1551().field_1772;
    protected Consumer<TextScrollAreaEntry> onClickCallback;

    public TextScrollAreaEntry(ScrollArea parent, @NotNull class_2561 text, @NotNull Consumer<TextScrollAreaEntry> onClick) {
        super(parent, 0, 14);
        this.onClickCallback = onClick;
        this.setText(text);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial) {

        super.render(graphics, mouseX, mouseY, partial);

        int centerY = this.getY() + (this.getHeight() / 2);

        graphics.drawString(this.font, this.text, (this.getX() + 5), (centerY - (this.font.field_2000 / 2)), UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);

    }

    @Override
    public void onClick(ScrollAreaEntry entry) {
        this.onClickCallback.accept((TextScrollAreaEntry) entry);
    }

    public void setText(@NotNull class_2561 text) {
        this.text = text;
        this.textWidth = this.font.method_27525(this.text);
        this.setWidth(5 + this.textWidth + 5);
    }

    public class_2561 getText() {
        return this.text;
    }

    public int getTextWidth() {
        return this.textWidth;
    }

}
