package de.keksuccino.fancymenu.util.rendering.ui.toast;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleToast implements class_368 {

    protected static final class_2960 field_2207 = new class_2960("textures/gui/toasts.png");
    
    public static final int PROGRESS_BAR_WIDTH = 154;
    public static final int PROGRESS_BAR_HEIGHT = 1;
    public static final int PROGRESS_BAR_X = 3;
    public static final int PROGRESS_BAR_Y = 28;

    @NotNull
    protected final Icon icon;
    @NotNull
    protected final class_2561 title;
    @Nullable
    protected final class_2561 message;
    protected class_368.class_369 visibility;
    protected long lastProgressTime;
    protected float lastProgress;
    protected float progress;
    protected final boolean progressable;
    @Nullable
    protected ResourceSupplier<ITexture> customBackground;
    int width = 160;
    int height = 32;

    public SimpleToast(@NotNull Icon icon, @NotNull class_2561 title, @Nullable class_2561 message, boolean progressable) {
        this.visibility = class_369.field_2210;
        this.icon = icon;
        this.title = title;
        this.message = message;
        this.progressable = progressable;
    }

    @NotNull
    @Override
    public class_369 method_1986(@NotNull class_4587 poseStack, @NotNull class_374 toastComponent, long timeSinceLastVisible) {
        return this.render(GuiGraphics.currentGraphics(), toastComponent, timeSinceLastVisible);
    }

    @NotNull
    protected class_368.class_369 render(@NotNull GuiGraphics graphics, @NotNull class_374 toastComponent, long progressTime) {

        class_2960 customBack = this.getCustomBackground();
        if (customBack == null) {
            graphics.blit(field_2207, 0, 0, 0, 96, this.method_29049(), this.method_29050());
        } else {
            graphics.blit(customBack, 0, 0, 0.0F, 0.0F, this.method_29049(), this.method_29050(), this.method_29049(), this.method_29050());
        }

        this.icon.render(graphics, 6, 6);

        if (this.message == null) {
            graphics.drawString(toastComponent.method_1995().field_1772, this.title, 30, 12, -11534256, false);
        } else {
            graphics.drawString(toastComponent.method_1995().field_1772, this.title, 30, 7, -11534256, false);
            graphics.drawString(toastComponent.method_1995().field_1772, this.message, 30, 18, -16777216, false);
        }

        if (this.progressable) {
            graphics.fill(PROGRESS_BAR_X, PROGRESS_BAR_Y, PROGRESS_BAR_X + PROGRESS_BAR_WIDTH, PROGRESS_BAR_Y + PROGRESS_BAR_HEIGHT, -1);
            float clampProgress = class_3532.method_37166(this.lastProgress, this.progress, (float)(progressTime - this.lastProgressTime) / 100.0F);
            int progressColor;
            if (this.progress >= this.lastProgress) {
                progressColor = -16755456;
            } else {
                progressColor = -11206656;
            }
            graphics.fill(PROGRESS_BAR_X, PROGRESS_BAR_Y, (int)((float)PROGRESS_BAR_X + (float)PROGRESS_BAR_WIDTH * clampProgress), PROGRESS_BAR_Y + PROGRESS_BAR_HEIGHT, progressColor);
            this.lastProgress = clampProgress;
            this.lastProgressTime = progressTime;
        }

        return this.visibility;

    }

    @Override
    public int method_29049() {
        return this.width;
    }

    @Override
    public int method_29050() {
        return this.height;
    }

    @NotNull
    public SimpleToast setHeight(int height) {
        this.height = height;
        return this;
    }

    @NotNull
    public SimpleToast setWidth(int width) {
        this.width = width;
        return this;
    }

    @Nullable
    protected class_2960 getCustomBackground() {
        if (this.customBackground != null) {
            ITexture tex = this.customBackground.get();
            if (tex != null) {
                return tex.getResourceLocation();
            }
        }
        return null;
    }

    @NotNull
    public SimpleToast setCustomBackground(@Nullable ResourceSupplier<ITexture> texture) {
        this.customBackground = texture;
        return this;
    }

    public void hide() {
        this.visibility = class_369.field_2209;
    }

    public void updateProgress(float progress) {
        this.progress = progress;
    }

    public static class Icon {

        protected class_2960 location;
        protected ResourceSupplier<ITexture> supplier;

        /**
         * A 20x20 pixels icon texture for displaying in the toast.
         */
        public Icon(@NotNull class_2960 textureLocation) {
            this.location = textureLocation;
        }

        /**
         * A 20x20 pixels icon texture for displaying in the toast.
         */
        public Icon(@NotNull ResourceSupplier<ITexture> textureSupplier) {
            this.supplier = textureSupplier;
        }

        public void render(GuiGraphics graphics, int x, int y) {
            class_2960 icon = this.getIcon();
            if (icon != null) {
                RenderSystem.enableBlend();
                graphics.blit(icon, x, y, 0.0F, 0.0F, 20, 20, 20, 20);
            }
        }

        @Nullable
        protected class_2960 getIcon() {
            if (this.location != null) return this.location;
            if (this.supplier != null) {
                ITexture tex = this.supplier.get();
                if (tex != null) {
                    return tex.getResourceLocation();
                }
            }
            return null;
        }

    }

}
