package de.keksuccino.fancymenu.util.rendering.ui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.platform.Services;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;

/**
 * A renderer for the branding text shown on the title screen.
 * This class allows for customizable positioning of the branding text.
 */
public class BrandingRenderer {

    private final class_327 font;
    private float opacity = 1.0F; // Default opacity
    private final int screenHeight;
    private final List<class_2561> lines;

    public BrandingRenderer(int screenHeight) {
        this.font = class_310.method_1551().field_1772;
        this.screenHeight = screenHeight;
        this.lines = Services.COMPAT.getTitleScreenBrandingLines();
    }

    /**
     * Sets the opacity for rendering the branding text.
     * @param opacity The opacity value (0.0F to 1.0F)
     * @return This renderer instance for method chaining
     */
    public BrandingRenderer setOpacity(float opacity) {
        this.opacity = opacity;
        return this;
    }

    /**
     * Gets the default X position for rendering branding (2 pixels from left).
     * @return The default X position
     */
    public int getDefaultPositionX() {
        return 2;
    }

    /**
     * Gets the default Y position for rendering branding.
     * This is the Y position of the top-most line of text.
     * @return The default Y position
     */
    public int getDefaultPositionY() {
        int totalHeight = getTotalHeight();
        int i = this.screenHeight - 2 - totalHeight;
        i += 1; // I don't know why either. It just looks better.
        return i;
    }

    /**
     * Calculates the total width of the branding text (width of the widest line).
     * @return The total width in pixels
     */
    public int getTotalWidth() {
        int width = 0;

        for (class_2561 line : lines) {
            int lineWidth = font.method_27525(line);
            if (lineWidth > width) {
                width = lineWidth;
            }
        }

        return width;
    }

    /**
     * Calculates the total height of the branding text.
     * @return The total height in pixels
     */
    public int getTotalHeight() {
        int totalHeight = (font.field_2000 + 1) * lines.size();
        if (totalHeight > 0) {
            totalHeight--;
        }
        return totalHeight;
    }

    /**
     * Renders the branding text at the default position.
     * @param graphics The GuiGraphics to render with
     */
    public void render(@NotNull GuiGraphics graphics) {
        render(graphics, getDefaultPositionX(), getDefaultPositionY());
    }

    /**
     * Renders the branding text at the specified position.
     * @param graphics The GuiGraphics to render with
     * @param x The x-coordinate to render at
     * @param y The y-coordinate of the top-most line of text
     */
    public void render(@NotNull GuiGraphics graphics, int x, int y) {

        RenderSystem.enableBlend();

        if (lines.isEmpty()) {
            return;
        }

        int currentY = y;
        for (class_2561 line : lines) {
            graphics.drawString(font, line, x, currentY, DrawableColor.WHITE.getColorIntWithAlpha(this.opacity));
            currentY += font.field_2000 + 1;
        }

    }

}