package de.keksuccino.fancymenu.util.rendering.ui.widget;

import de.keksuccino.fancymenu.util.rendering.gui.Axis;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.QuaternionUtils;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public class MinecraftSplashRenderer {

    public static final int WIDTH_OFFSET = 123;
    public static final int HEIGHT_OFFSET = 69;

    private static MinecraftSplashRenderer defaultInstance = null;
    private static MinecraftSplashRenderer fallbackInstance = new MinecraftSplashRenderer("ERROR");

    private final String splash;

    public MinecraftSplashRenderer(String splash) {
        this.splash = splash;
    }

    public int getDefaultPositionX(int screenWidth) {
        return (int)(((float)screenWidth / 2.0F) + WIDTH_OFFSET);
    }

    public int getDefaultPositionY() {
        return HEIGHT_OFFSET;
    }

    /**
     * Renders the splash text at the default position.
     *
     * @param guiGraphics the graphics context to render with
     * @param screenWidth the width of the screen
     * @param font the font to use for rendering
     * @param color the color of the text
     */
    public void render(GuiGraphics guiGraphics, int screenWidth, class_327 font, int color) {
        guiGraphics.pose().method_22903();
        guiGraphics.pose().method_22904((float)screenWidth / 2.0F + WIDTH_OFFSET, HEIGHT_OFFSET, 0.0F);
        guiGraphics.pose().method_22907(QuaternionUtils.toMojangQuaternion(Axis.ZP.rotationDegrees(-20.0F)));
        float f = 1.8F - class_3532.method_15379(class_3532.method_15374((float)(class_156.method_658() % 1000L) / 1000.0F * (float) (Math.PI * 2)) * 0.1F);
        f = f * 100.0F / (float)(font.method_1727(this.splash) + 32);
        guiGraphics.pose().method_22905(f, f, f);
        guiGraphics.drawCenteredString(font, this.splash, 0, -8, 16776960 | color);
        guiGraphics.pose().method_22909();
    }

    /**
     * Renders the splash text centered at the specified position.
     *
     * @param guiGraphics the graphics context to render with
     * @param x the x-coordinate to center the splash text at
     * @param y the y-coordinate to center the splash text at
     * @param font the font to use for rendering
     * @param color the color of the text
     */
    public void renderAt(GuiGraphics guiGraphics, int x, int y, class_327 font, int color) {

        guiGraphics.pose().method_22903();

        // Translate to the specified position
        guiGraphics.pose().method_22904(x, y, 0.0F);

        // Apply the same rotation as the original
        guiGraphics.pose().method_22907(QuaternionUtils.toMojangQuaternion(Axis.ZP.rotationDegrees(-20.0F)));

        // Calculate the pulsing scale factor
        float f = 1.8F - class_3532.method_15379(class_3532.method_15374((float)(class_156.method_658() % 1000L) / 1000.0F * (float) (Math.PI * 2)) * 0.1F);
        f = f * 100.0F / (float)(font.method_1727(this.splash) + 32);

        // Apply scaling
        guiGraphics.pose().method_22905(f, f, f);

        // Draw the centered text at the origin (which is now at x,y)
        // The -8 vertical offset keeps consistent vertical alignment from the original
        guiGraphics.drawCenteredString(font, this.splash, 0, -8, 16776960 | color);

        guiGraphics.pose().method_22909();

    }

    /**
     * Gets the splash text.
     *
     * @return the splash text
     */
    public String getSplash() {
        return this.splash;
    }

    @NotNull
    public static MinecraftSplashRenderer getDefaultInstance() {
        String vanilla = class_310.method_1551().method_18095().method_18174();
        if (vanilla != null) {
            if (defaultInstance == null) {
                defaultInstance = new MinecraftSplashRenderer(vanilla);
            }
            return defaultInstance;
        }
        return fallbackInstance;
    }

}