package de.keksuccino.fancymenu.util.rendering.ui.widget.component;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.FancyMenuWidget;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_6382;

@SuppressWarnings("unused")
public class ComponentWidget extends class_339 implements NavigatableWidget, FancyMenuWidget {

    private static final Logger LOGGER = LogManager.getLogger();

    @NotNull
    protected ConsumingSupplier<ComponentWidget, class_5250> textSupplier;
    protected boolean shadow = true;
    @NotNull
    protected ConsumingSupplier<ComponentWidget, DrawableColor> baseColorSupplier = (var) -> UIBase.getUIColorTheme().generic_text_base_color;
    protected Consumer<ComponentWidget> onHoverOrFocusStart;
    protected Consumer<ComponentWidget> onHoverOrFocusEnd;
    protected Consumer<ComponentWidget> onClick;
    @Nullable
    protected ComponentWidget parent;
    protected List<ComponentWidget> children = new ArrayList<>();
    @NotNull
    protected class_327 font;
    protected boolean isCurrentlyHoveredOrFocused = false;
    protected int endX;

    public static ComponentWidget of(@NotNull class_5250 component, int x, int y) {
        return new ComponentWidget(class_310.method_1551().field_1772, x, y, component);
    }

    public static ComponentWidget literal(@NotNull String text, int x, int y) {
        ComponentWidget w = new ComponentWidget(class_310.method_1551().field_1772, x, y, Components.literal(""));
        w.setTextSupplier(consumes -> Components.literal(PlaceholderParser.replacePlaceholders(text)));
        return w;
    }

    public static ComponentWidget translatable(@NotNull String key, int x, int y) {
        ComponentWidget w = new ComponentWidget(class_310.method_1551().field_1772, x, y, Components.literal(""));
        w.setTextSupplier(consumes -> Components.translatable(key));
        return w;
    }

    public static ComponentWidget empty(int x, int y) {
        return new ComponentWidget(class_310.method_1551().field_1772, x, y, Components.literal(""));
    }

    protected ComponentWidget(@NotNull class_327 font, int x, int y, @NotNull class_5250 text) {
        super(x, y, 0, 0, text);
        this.textSupplier = (var) -> text;
        this.font = font;
    }

    public int getX() {
        return this.field_22760;
    }

    public void setX(int x) {
        this.field_22760 = x;
    }

    public int getY() {
        return this.field_22761;
    }

    public void setY(int y) {
        this.field_22761 = y;
    }

    public void method_25358(int width) {
        this.field_22758 = width;
    }

    public void setHeight(int height) {
        this.field_22759 = height;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.field_22758 = this.method_25368();
        this.field_22759 = this.method_25364();
        super.method_25394(graphics.pose(), mouseX, mouseY, partial);
    }

    @Deprecated
    @Override
    public void method_25394(@NotNull class_4587 pose, int mouseX, int mouseY, float partial) {
        this.render(GuiGraphics.currentGraphics(), mouseX, mouseY, partial);
    }

    @Override
    public void method_25359(@NotNull class_4587 pose, int mouseX, int mouseY, float partial) {

        this.handleComponentHover();

        RenderSystem.enableBlend();

        this.endX = this.field_22760;
        if (this.shadow) {
            this.endX = this.font.method_30881(pose, this.getText(), this.field_22760, this.field_22761, this.getBaseColor().getColorInt());
        } else {
            this.endX = this.font.method_30883(pose, this.getText(), this.field_22760, this.field_22761, this.getBaseColor().getColorInt());
        }

        for (ComponentWidget c : this.children) {
            c.field_22760 = this.endX;
            c.field_22761 = this.field_22761;
            c.method_25394(pose, mouseX, mouseY, partial);
            this.endX = c.endX;
        }

    }

    public ComponentWidget append(@NotNull ComponentWidget child) {
        child.parent = this;
        this.children.add(child);
        return this;
    }

    public List<ComponentWidget> getChildren() {
        return this.children;
    }

    @Nullable
    public ComponentWidget getParent() {
        return this.parent;
    }

    @NotNull
    public ConsumingSupplier<ComponentWidget, class_5250> getTextSupplier() {
        return this.textSupplier;
    }

    public ComponentWidget setTextSupplier(@NotNull ConsumingSupplier<ComponentWidget, class_5250> textSupplier) {
        this.textSupplier = textSupplier;
        return this;
    }

    @NotNull
    public class_5250 getText() {
        class_5250 c = this.textSupplier.get(this);
        if (c == null) c = Components.literal("");
        return c;
    }

    public ComponentWidget setText(@NotNull class_5250 text) {
        this.textSupplier = (var) -> text;
        return this;
    }

    public boolean hasShadow() {
        return this.shadow;
    }

    public ComponentWidget setShadow(boolean shadow) {
        this.shadow = shadow;
        for (ComponentWidget w : this.children) {
            w.shadow = shadow;
        }
        return this;
    }

    public ComponentWidget setBaseColor(@NotNull DrawableColor baseColor) {
        this.baseColorSupplier = (var) -> baseColor;
        for (ComponentWidget w : this.children) {
            w.baseColorSupplier = this.baseColorSupplier;
        }
        return this;
    }

    @NotNull
    public DrawableColor getBaseColor() {
        DrawableColor c = this.baseColorSupplier.get(this);
        if (c == null) c = DrawableColor.WHITE;
        return c;
    }

    public ComponentWidget setBaseColorSupplier(@NotNull ConsumingSupplier<ComponentWidget, DrawableColor> baseColorSupplier) {
        this.baseColorSupplier = baseColorSupplier;
        for (ComponentWidget w : this.children) {
            w.baseColorSupplier = baseColorSupplier;
        }
        return this;
    }

    @NotNull
    public ConsumingSupplier<ComponentWidget, DrawableColor> getBaseColorSupplier() {
        return this.baseColorSupplier;
    }

    public ComponentWidget setOnHoverOrFocusStart(@Nullable Consumer<ComponentWidget> onHoverOrFocusStart) {
        this.onHoverOrFocusStart = onHoverOrFocusStart;
        return this;
    }

    public ComponentWidget setOnHoverOrFocusEnd(@Nullable Consumer<ComponentWidget> onHoverOrFocusEnd) {
        this.onHoverOrFocusEnd = onHoverOrFocusEnd;
        return this;
    }

    public ComponentWidget setOnClick(@Nullable Consumer<ComponentWidget> onClick) {
        this.onClick = onClick;
        return this;
    }

    @Override
    public int method_25368() {
        int w = this.font.method_27525(this.getText());
        for (ComponentWidget c : this.children) {
            w += c.method_25368();
        }
        return w;
    }

    @Override
    public int method_25364() {
        return this.font.field_2000;
    }

    protected void handleComponentHover() {
        if (!this.isCurrentlyHoveredOrFocused) {
            if (this.method_25367()) {
                if (this.onHoverOrFocusStart != null) {
                    this.onHoverOrFocusStart.accept(this);
                }
                this.isCurrentlyHoveredOrFocused = true;
            }
        } else if (!this.method_25367()) {
            if (this.onHoverOrFocusEnd != null) {
                this.onHoverOrFocusEnd.accept(this);
            }
            this.isCurrentlyHoveredOrFocused = false;
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.field_22763 && this.field_22764 && this.method_25367() && (button == 0)) {
            for (ComponentWidget w : this.children) {
                if (w.method_25402(mouseX, mouseY, button)) return true;
            }
            if (this.onClick != null) {
                this.onClick.accept(this);
                return true;
            }
        }
        return false;
    }

    @Override
    public void method_37020(@NotNull class_6382 var1) {
    }

    @Deprecated
    @Override
    public void method_25355(@NotNull class_2561 content) {
        if (content instanceof class_5250 m) this.textSupplier = (var) -> m;
    }

    @Deprecated
    @Override
    public @NotNull class_2561 method_25369() {
        return this.getText();
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setFocusable(boolean focusable) {
        throw new RuntimeException("ComponentWidgets are not focusable!");
    }

    @Override
    public boolean isNavigatable() {
        return false;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
        throw new RuntimeException("ComponentWidgets are not navigatable!");
    }

}
