package de.keksuccino.fancymenu.util.rendering.ui.widget.slider.v1;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.UniqueWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.FancyMenuWidget;
import de.keksuccino.konkrete.input.MouseInput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.awt.*;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_4587;
import net.minecraft.class_5244;

@Deprecated
public abstract class ExtendedSliderButton extends class_357 implements UniqueWidget, NavigatableWidget, FancyMenuWidget {

    protected static final class_2960 SLIDER_LOCATION = new class_2960("textures/gui/slider.png");

    protected static boolean leftDownGlobal = false;

    public boolean handleClick;
    public boolean enableRightClick = false;
    public boolean ignoreBlockedInput = false;
    public boolean ignoreGlobalLeftMouseDown = false;
    protected String messagePrefix = null;
    protected String messageSuffix = null;
    protected Consumer<ExtendedSliderButton> applyValueCallback;
    @Nullable
    protected DrawableColor backgroundColor = null;
    @Nullable
    protected DrawableColor borderColor = null;
    @Nullable
    protected DrawableColor handleColorNormal = null;
    @Nullable
    protected DrawableColor handleColorHover = null;
    @NotNull
    protected DrawableColor labelColorNormal = DrawableColor.of(new Color(16777215));
    @NotNull
    protected DrawableColor labelColorInactive = DrawableColor.of(new Color(10526880));
    protected boolean labelShadow = true;
    @Nullable
    protected String identifier;
    protected boolean focusable = true;
    protected boolean navigatable = true;

    protected boolean leftDownNotHovered = false;
    protected boolean leftDownThis = false;

    @Deprecated
    public ExtendedSliderButton(int x, int y, int width, int height, boolean handleClick, double value, Consumer<ExtendedSliderButton> applyValueCallback) {
        super(x, y, width, height, class_5244.field_39003, value);
        this.handleClick = handleClick;
        this.applyValueCallback = applyValueCallback;
    }

    public int getX() {
        return this.field_22760;
    }

    public void setX(int x) {
        this.field_22760 = x;
    }

    public int getY() {
        return this.field_22761;
    }

    public void setY(int y) {
        this.field_22761 = y;
    }

    public int method_25368() {
        return this.field_22758;
    }

    public void method_25358(int width) {
        this.field_22758 = width;
    }

    public int method_25364() {
        return this.field_22759;
    }

    public void setHeight(int height) {
        this.field_22759 = height;
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.renderBackground(graphics);
        this.renderHandle(graphics);
        int labelColorInt = this.field_22763 ? this.labelColorNormal.getColorInt() : this.labelColorInactive.getColorInt();
        this.renderScrollingLabel(graphics, class_310.method_1551().field_1772, 2, labelColorInt | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
        RenderingUtils.resetShaderColor(graphics);
    }

    protected void renderHandle(@NotNull GuiGraphics graphics) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        int handleX = this.field_22760 + (int)(this.field_22753 * (double)(this.field_22758 - 8));
        DrawableColor c = this.getHandleRenderColor();
        if (c == null) {
            graphics.setColor(1.0F, 1.0F, 1.0F, this.field_22765);
            graphics.blitNineSliced(SLIDER_LOCATION, handleX, this.field_22761, 8, 20, 20, 4, 200, 20, 0, this.getHandleTextureY());
        } else {
            graphics.fill(handleX, this.field_22761, handleX + 8, this.field_22761 + this.method_25364(), RenderingUtils.replaceAlphaInColor(c.getColorInt(), this.field_22765));
        }
        RenderingUtils.resetShaderColor(graphics);
    }

    @Nullable
    protected DrawableColor getHandleRenderColor() {
        if (this.field_22762 && (this.handleColorHover != null)) return this.handleColorHover;
        return this.handleColorNormal;
    }

    protected void renderBackground(@NotNull GuiGraphics graphics) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        if (this.backgroundColor == null) {
            graphics.setColor(1.0F, 1.0F, 1.0F, this.field_22765);
            graphics.blitNineSliced(SLIDER_LOCATION, this.field_22760, this.field_22761, this.method_25368(), this.method_25364(), 20, 4, 200, 20, 0, this.getTextureY());
        } else {
            int borderOffset = (this.borderColor != null) ? 1 : 0;
            graphics.fill(this.field_22760 + borderOffset, this.field_22761 + borderOffset, this.field_22760 + this.method_25368() - borderOffset, this.field_22761 + this.method_25364() - borderOffset, RenderingUtils.replaceAlphaInColor(this.backgroundColor.getColorInt(), this.field_22765));
            if (this.borderColor != null) {
                UIBase.renderBorder(graphics, this.field_22760, this.field_22761, this.field_22760 + this.method_25368(), this.field_22761 + this.method_25364(), 1, this.borderColor, true, true, true, true);
            }
        }
        RenderingUtils.resetShaderColor(graphics);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {

        if (this.field_22764) {

            this.field_22762 = mouseX >= this.field_22760 && mouseY >= this.field_22761 && mouseX < this.field_22760 + this.field_22758 && mouseY < this.field_22761 + this.field_22759;

            if (!this.method_25367() && MouseInput.isLeftMouseDown()) {
                this.leftDownNotHovered = true;
            }
            if (!MouseInput.isLeftMouseDown()) {
                this.leftDownNotHovered = false;
            }

            if (this.handleClick) {
                if (this.method_25367() && (MouseInput.isLeftMouseDown() || (this.enableRightClick && MouseInput.isRightMouseDown())) && (!leftDownGlobal || this.ignoreGlobalLeftMouseDown) && !leftDownNotHovered && !this.isInputBlocked() && this.field_22763 && this.field_22764) {
                    if (!this.leftDownThis) {
                        this.method_25348(mouseX, mouseY);
                        leftDownGlobal = true;
                        this.leftDownThis = true;
                    }
                }
                if (!MouseInput.isLeftMouseDown() && !(MouseInput.isRightMouseDown() && this.enableRightClick)) {
                    leftDownGlobal = false;
                    if (this.leftDownThis) {
                        this.method_25357(mouseX, mouseY);
                    }
                    this.leftDownThis = false;
                }
                if (this.leftDownThis) {
                    this.method_25349(mouseX, mouseY, 0, 0);
                }
            }

        }

        super.method_25394(graphics.pose(), mouseX, mouseY, partial);
        this.renderWidget(GuiGraphics.currentGraphics(), mouseX, mouseY, partial);

    }

    @Deprecated
    @Override
    public void method_25394(@NotNull class_4587 pose, int mouseX, int mouseY, float partial) {
        this.render(GuiGraphics.currentGraphics(), mouseX, mouseY, partial);
    }

    protected void renderScrollingLabel(@NotNull GuiGraphics graphics, @NotNull class_327 font, int spaceLeftRight, int textColor) {
        int xMin = this.field_22760 + spaceLeftRight;
        int xMax = this.field_22760 + this.method_25368() - spaceLeftRight;
        this.renderScrollingLabelInternal(graphics, font, this.method_25369(), xMin, this.field_22761, xMax, this.field_22761 + this.method_25364(), textColor);
    }

    protected void renderScrollingLabelInternal(@NotNull GuiGraphics graphics, class_327 font, @NotNull class_2561 text, int xMin, int yMin, int xMax, int yMax, int textColor) {
        int textWidth = font.method_27525(text);
        int textPosY = (yMin + yMax - 9) / 2 + 1;
        int maxTextWidth = xMax - xMin;
        if (textWidth > maxTextWidth) {
            int diffTextWidth = textWidth - maxTextWidth;
            double scrollTime = (double) class_156.method_658() / 1000.0D;
            double $$13 = Math.max((double)diffTextWidth * 0.5D, 3.0D);
            double $$14 = Math.sin((Math.PI / 2D) * Math.cos((Math.PI * 2D) * scrollTime / $$13)) / 2.0D + 0.5D;
            double textPosX = class_3532.method_16436($$14, 0.0D, diffTextWidth);
            graphics.enableScissor(xMin, yMin, xMax, yMax);
            graphics.drawString(font, text, xMin - (int)textPosX, textPosY, textColor, this.labelShadow);
            graphics.disableScissor();
        } else {
            graphics.drawString(font, text, (int)(((xMin + xMax) / 2F) - (font.method_27525(text) / 2F)), textPosY, textColor, this.labelShadow);
        }
    }

    @Nullable
    public DrawableColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(@Nullable DrawableColor backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Nullable
    public DrawableColor getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(@Nullable DrawableColor borderColor) {
        this.borderColor = borderColor;
    }

    @Nullable
    public DrawableColor getHandleColorNormal() {
        return this.handleColorNormal;
    }

    public void setHandleColorNormal(@Nullable DrawableColor handleColorNormal) {
        this.handleColorNormal = handleColorNormal;
    }

    @Nullable
    public DrawableColor getHandleColorHover() {
        return this.handleColorHover;
    }

    public void setHandleColorHover(@Nullable DrawableColor handleColorHover) {
        this.handleColorHover = handleColorHover;
    }

    @NotNull
    public DrawableColor getLabelColorNormal() {
        return this.labelColorNormal;
    }

    public void setLabelColorNormal(@NotNull DrawableColor labelColorNormal) {
        this.labelColorNormal = labelColorNormal;
    }

    @NotNull
    public DrawableColor getLabelColorInactive() {
        return this.labelColorInactive;
    }

    public void setLabelColorInactive(@NotNull DrawableColor labelColorInactive) {
        this.labelColorInactive = labelColorInactive;
    }

    public boolean isLabelShadow() {
        return this.labelShadow;
    }

    public void setLabelShadow(boolean labelShadow) {
        this.labelShadow = labelShadow;
    }

    public boolean canChangeValue() {
        return true;
    }

    protected int getTextureY() {
        int $$0 = this.method_25370() && !this.canChangeValue() ? 1 : 0;
        return $$0 * 20;
    }

    protected int getHandleTextureY() {
        int $$0 = !this.field_22762 && !this.canChangeValue() ? 2 : 3;
        return $$0 * 20;
    }

    @Override
    protected void method_25349(double mouseX, double mouseY, double d1, double d2) {
        super.method_25349(mouseX, mouseY, d1, d2);
    }

    @Override
    public void method_25348(double mouseX, double mouseY) {
        super.method_25348(mouseX, mouseY);
    }

    @Override
    public void method_25357(double mouseX, double mouseY) {
        super.method_25357(mouseX, mouseY);
    }

    @Override
    protected void method_25344() {
        if (this.applyValueCallback != null) {
            this.applyValueCallback.accept(this);
        }
    }

    @Override
    public void method_25346() {
        String s = "";
        if (this.messagePrefix != null) {
            s += this.messagePrefix;
        }
        s += this.getSliderMessageWithoutPrefixSuffix();
        if (this.messageSuffix != null) {
            s += this.messageSuffix;
        }
        this.method_25355(class_2561.method_43470(s));
    }

    public abstract String getSliderMessageWithoutPrefixSuffix();

    public void setLabelPrefix(String prefix) {
        this.messagePrefix = prefix;
        this.method_25346();
    }

    public void setLabelSuffix(String suffix) {
        this.messageSuffix = suffix;
        this.method_25346();
    }

    public void method_25347(double value) {
        double d0 = this.field_22753;
        this.field_22753 = class_3532.method_15350(value, 0.0D, 1.0D);
        if (d0 != this.field_22753) {
            this.method_25344();
        }
        this.method_25346();
    }

    public double getValue() {
        return this.field_22753;
    }

    protected boolean isInputBlocked() {
        if (this.ignoreBlockedInput) {
            return false;
        }
        return MouseInput.isVanillaInputBlocked();
    }

    @Override
    public @Nullable String getWidgetIdentifierFancyMenu() {
        return this.identifier;
    }

    @Override
    public ExtendedSliderButton setWidgetIdentifierFancyMenu(@Nullable String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Override
    public void method_25365(boolean focused) {
        if (!this.focusable) {
            super.method_25365(false);
            return;
        }
        super.method_25365(focused);
    }

    @Override
    public boolean method_25370() {
        if (!this.focusable) return false;
        return super.method_25370();
    }

    @Override
    public boolean isFocusable() {
        return this.focusable;
    }

    @Override
    public void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    @Override
    public boolean isNavigatable() {
        return this.navigatable;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
        this.navigatable = navigatable;
    }

}
