/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.util.file.FileUtils;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ActionFavoritesManager {
    public static final File FAVORITES_FILE = new File(FancyMenu.INSTANCE_DATA_DIR, "/action_favorites.json");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type FAVORITES_TYPE = new TypeToken<List<String>>(){}.getType();
    private static final List<String> FAVORITES = new ArrayList<String>();
    private static boolean initialized = false;

    private ActionFavoritesManager() {
    }

    protected static void read() {
        FAVORITES.clear();
        try {
            if (!FancyMenu.INSTANCE_DATA_DIR.exists()) {
                FancyMenu.INSTANCE_DATA_DIR.mkdirs();
            }
            FAVORITES_FILE.createNewFile();
            List<String> jsonLines = FileUtils.readTextLinesFrom(FAVORITES_FILE);
            StringBuilder builder = new StringBuilder();
            jsonLines.forEach(builder::append);
            if (builder.toString().isBlank()) {
                return;
            }
            List identifiers = (List)GSON.fromJson(builder.toString(), FAVORITES_TYPE);
            if (identifiers != null) {
                LinkedHashSet<String> unique = new LinkedHashSet<String>();
                for (String identifier : identifiers) {
                    if (identifier == null || identifier.isBlank()) continue;
                    unique.add(identifier);
                }
                FAVORITES.addAll(unique);
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to read action favorites from file!", (Throwable)ex);
        }
    }

    protected static void write() {
        if (!initialized) {
            ActionFavoritesManager.read();
        }
        initialized = true;
        try {
            if (!FancyMenu.INSTANCE_DATA_DIR.exists()) {
                FancyMenu.INSTANCE_DATA_DIR.mkdirs();
            }
            FAVORITES_FILE.createNewFile();
            String json = GSON.toJson(FAVORITES, FAVORITES_TYPE);
            FileUtils.writeTextToFile((File)FAVORITES_FILE, (boolean)false, (String[])new String[]{Objects.requireNonNull(json)});
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to write action favorites to file!", (Throwable)ex);
        }
    }

    @NotNull
    public static List<String> getFavorites() {
        if (!initialized) {
            ActionFavoritesManager.read();
        }
        initialized = true;
        return new ArrayList<String>(FAVORITES);
    }

    public static boolean isFavorite(@NotNull String identifier) {
        Objects.requireNonNull(identifier);
        if (!initialized) {
            ActionFavoritesManager.read();
        }
        initialized = true;
        return FAVORITES.contains(identifier);
    }

    public static void addFavorite(@NotNull String identifier) {
        Objects.requireNonNull(identifier);
        if (!initialized) {
            ActionFavoritesManager.read();
        }
        initialized = true;
        if (!FAVORITES.contains(identifier)) {
            FAVORITES.add(identifier);
            ActionFavoritesManager.write();
        }
    }

    public static void removeFavorite(@NotNull String identifier) {
        Objects.requireNonNull(identifier);
        if (!initialized) {
            ActionFavoritesManager.read();
        }
        initialized = true;
        if (FAVORITES.remove(identifier)) {
            ActionFavoritesManager.write();
        }
    }

    public static void toggleFavorite(@NotNull String identifier) {
        Objects.requireNonNull(identifier);
        if (ActionFavoritesManager.isFavorite(identifier)) {
            ActionFavoritesManager.removeFavorite(identifier);
        } else {
            ActionFavoritesManager.addFavorite(identifier);
        }
    }

    public static void retainFavorites(@NotNull Set<String> validIdentifiers) {
        Objects.requireNonNull(validIdentifiers);
        if (!initialized) {
            ActionFavoritesManager.read();
        }
        initialized = true;
        boolean changed = FAVORITES.removeIf(identifier -> !validIdentifiers.contains(identifier));
        if (changed) {
            ActionFavoritesManager.write();
        }
    }
}

