/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.background.backgrounds.image;

import de.keksuccino.fancymenu.customization.background.MenuBackground;
import de.keksuccino.fancymenu.customization.background.MenuBackgroundBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.rendering.AspectRatio;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.resource.PlayableResource;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;

public class ImageMenuBackground
extends MenuBackground {
    private static final DrawableColor BACKGROUND_COLOR = DrawableColor.BLACK;
    public ResourceSupplier<ITexture> textureSupplier;
    public ResourceSupplier<ITexture> fallbackTextureSupplier;
    public boolean slideLeftRight = false;
    public boolean repeat = false;
    public boolean parallaxEnabled = false;
    @NotNull
    public String parallaxIntensityString = "0.02";
    public float lastParallaxIntensity = -10000.0f;
    public boolean invertParallax = false;
    public boolean restartAnimatedOnMenuLoad = false;
    protected double slidePos = 0.0;
    protected boolean slideMoveBack = false;
    protected boolean slideStop = false;
    protected int slideTick = 0;

    public ImageMenuBackground(MenuBackgroundBuilder<ImageMenuBackground> builder) {
        super(builder);
    }

    @Override
    public void onOpenScreen() {
        super.onOpenScreen();
        if (this.restartAnimatedOnMenuLoad) {
            PlayableResource r;
            ITexture tex;
            if (this.textureSupplier != null && (tex = this.textureSupplier.get()) instanceof PlayableResource) {
                r = (PlayableResource)((Object)tex);
                r.stop();
                r.play();
            }
            if (this.fallbackTextureSupplier != null && (tex = this.fallbackTextureSupplier.get()) instanceof PlayableResource) {
                r = (PlayableResource)((Object)tex);
                r.stop();
                r.play();
            }
        }
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        ITexture fallback;
        ITexture background;
        this.lastParallaxIntensity = SerializationUtils.deserializeNumber(Float.class, Float.valueOf(0.02f), PlaceholderParser.replacePlaceholders(this.parallaxIntensityString)).floatValue();
        class_2960 resourceLocation = null;
        ITexture tex = null;
        AspectRatio ratio = new AspectRatio(10, 10);
        if (this.textureSupplier != null && (background = this.textureSupplier.get()) != null) {
            tex = background;
            ratio = background.getAspectRatio();
            resourceLocation = background.getResourceLocation();
        }
        if (resourceLocation == null && this.fallbackTextureSupplier != null && (fallback = this.fallbackTextureSupplier.get()) != null) {
            tex = fallback;
            ratio = fallback.getAspectRatio();
            resourceLocation = fallback.getResourceLocation();
        }
        if (resourceLocation != null) {
            float[] parallaxOffset = this.calculateParallaxOffset(mouseX, mouseY);
            if (this.repeat) {
                this.renderRepeatBackground(graphics, resourceLocation, tex, parallaxOffset);
            } else if (this.slideLeftRight && !this.parallaxEnabled) {
                this.renderSlideBackground(graphics, ratio, resourceLocation, parallaxOffset);
            } else if (this.keepBackgroundAspectRatio) {
                this.renderKeepAspectRatio(graphics, ratio, resourceLocation, parallaxOffset);
            } else {
                this.renderFullScreen(graphics, resourceLocation, parallaxOffset);
            }
        }
    }

    protected float[] calculateParallaxOffset(int mouseX, int mouseY) {
        if (!this.parallaxEnabled) {
            return new float[]{0.0f, 0.0f};
        }
        float mouseXPercent = 2.0f * (float)mouseX / (float)ImageMenuBackground.getScreenWidth() - 1.0f;
        float mouseYPercent = 2.0f * (float)mouseY / (float)ImageMenuBackground.getScreenHeight() - 1.0f;
        float directionMultiplier = this.invertParallax ? 1.0f : -1.0f;
        float xOffset = directionMultiplier * this.lastParallaxIntensity * mouseXPercent * (float)ImageMenuBackground.getScreenWidth() * 0.5f;
        float yOffset = directionMultiplier * this.lastParallaxIntensity * mouseYPercent * (float)ImageMenuBackground.getScreenHeight() * 0.5f;
        return new float[]{xOffset, yOffset};
    }

    protected void renderRepeatBackground(@NotNull class_332 graphics, @NotNull class_2960 resourceLocation, ITexture tex, float[] parallaxOffset) {
        if (this.parallaxEnabled) {
            int expandedWidth = (int)((float)ImageMenuBackground.getScreenWidth() * (1.0f + this.lastParallaxIntensity));
            int expandedHeight = (int)((float)ImageMenuBackground.getScreenHeight() * (1.0f + this.lastParallaxIntensity));
            int baseX = -((expandedWidth - ImageMenuBackground.getScreenWidth()) / 2) + (int)parallaxOffset[0];
            int baseY = -((expandedHeight - ImageMenuBackground.getScreenHeight()) / 2) + (int)parallaxOffset[1];
            RenderingUtils.blitRepeat(graphics, resourceLocation, baseX, baseY, expandedWidth, expandedHeight, tex.getWidth(), tex.getHeight(), DrawableColor.WHITE.getColorIntWithAlpha(this.opacity));
        } else {
            RenderingUtils.blitRepeat(graphics, resourceLocation, 0, 0, ImageMenuBackground.getScreenWidth(), ImageMenuBackground.getScreenHeight(), tex.getWidth(), tex.getHeight(), DrawableColor.WHITE.getColorIntWithAlpha(this.opacity));
        }
    }

    protected void renderSlideBackground(@NotNull class_332 graphics, @NotNull AspectRatio ratio, @NotNull class_2960 resourceLocation, float[] parallaxOffset) {
        int w = ratio.getAspectRatioWidth(ImageMenuBackground.getScreenHeight());
        this.handleSlideAnimation(w);
        if (w <= ImageMenuBackground.getScreenWidth()) {
            if (this.keepBackgroundAspectRatio) {
                this.renderKeepAspectRatio(graphics, ratio, resourceLocation, parallaxOffset);
            } else {
                this.renderFullScreen(graphics, resourceLocation, parallaxOffset);
            }
        } else {
            float finalX = (float)this.slidePos;
            RenderingUtils.blitF(graphics, class_10799.field_56883, resourceLocation, finalX, parallaxOffset[1], 0.0f, 0.0f, w, ImageMenuBackground.getScreenHeight(), w, ImageMenuBackground.getScreenHeight(), class_9848.method_61317((float)this.opacity));
        }
    }

    protected void renderKeepAspectRatio(@NotNull class_332 graphics, @NotNull AspectRatio ratio, @NotNull class_2960 resourceLocation, float[] parallaxOffset) {
        float parallaxScale = this.parallaxEnabled ? 1.0f + this.lastParallaxIntensity : 1.0f;
        int[] baseSize = ratio.getAspectRatioSizeByMinimumSize((int)((float)ImageMenuBackground.getScreenWidth() * parallaxScale), (int)((float)ImageMenuBackground.getScreenHeight() * parallaxScale));
        int x = (ImageMenuBackground.getScreenWidth() - baseSize[0]) / 2 + (int)parallaxOffset[0];
        int y = (ImageMenuBackground.getScreenHeight() - baseSize[1]) / 2 + (int)parallaxOffset[1];
        graphics.method_25291(class_10799.field_56883, resourceLocation, x, y, 0.0f, 0.0f, baseSize[0], baseSize[1], baseSize[0], baseSize[1], class_9848.method_61317((float)this.opacity));
    }

    protected void renderFullScreen(@NotNull class_332 graphics, @NotNull class_2960 resourceLocation, float[] parallaxOffset) {
        if (this.parallaxEnabled) {
            int expandedWidth = (int)((float)ImageMenuBackground.getScreenWidth() * (1.0f + this.lastParallaxIntensity));
            int expandedHeight = (int)((float)ImageMenuBackground.getScreenHeight() * (1.0f + this.lastParallaxIntensity));
            int x = -((expandedWidth - ImageMenuBackground.getScreenWidth()) / 2) + (int)parallaxOffset[0];
            int y = -((expandedHeight - ImageMenuBackground.getScreenHeight()) / 2) + (int)parallaxOffset[1];
            graphics.method_25291(class_10799.field_56883, resourceLocation, x, y, 0.0f, 0.0f, expandedWidth, expandedHeight, expandedWidth, expandedHeight, class_9848.method_61317((float)this.opacity));
        } else {
            graphics.method_25291(class_10799.field_56883, resourceLocation, 0, 0, 0.0f, 0.0f, ImageMenuBackground.getScreenWidth(), ImageMenuBackground.getScreenHeight(), ImageMenuBackground.getScreenWidth(), ImageMenuBackground.getScreenHeight(), class_9848.method_61317((float)this.opacity));
        }
    }

    protected void handleSlideAnimation(int backgroundWidth) {
        if (this.slidePos + (double)(backgroundWidth - ImageMenuBackground.getScreenWidth()) <= 0.0) {
            this.slideMoveBack = true;
        }
        if (this.slidePos >= 0.0) {
            this.slideMoveBack = false;
        }
        if (this.slidePos + (double)(backgroundWidth - ImageMenuBackground.getScreenWidth()) < 0.0) {
            this.slidePos = -(backgroundWidth - ImageMenuBackground.getScreenWidth());
        }
        if (this.slidePos > 0.0) {
            this.slidePos = 0.0;
        }
        if (!this.slideStop) {
            if (this.slideTick >= 1) {
                this.slideTick = 0;
                this.slidePos += this.slideMoveBack ? 0.5 : -0.5;
                if (this.slidePos + (double)(backgroundWidth - ImageMenuBackground.getScreenWidth()) == 0.0 || this.slidePos == 0.0) {
                    this.slideStop = true;
                }
            } else {
                ++this.slideTick;
            }
        } else if (this.slideTick >= 300) {
            this.slideStop = false;
            this.slideTick = 0;
        } else {
            ++this.slideTick;
        }
    }
}

