/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.item;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.elements.item.NBTBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.konkrete.input.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9290;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    public class_1799 cachedStack = null;
    @NotNull
    public String itemKey = String.valueOf(class_7923.field_41178.method_10221((Object)class_1802.field_8077));
    public boolean enchanted = false;
    @NotNull
    public String itemCount = "1";
    @Nullable
    public String lore = null;
    @Nullable
    public String itemName = null;
    public boolean showTooltip = true;
    @Nullable
    public String nbtData = null;
    protected String lastItemKey = null;
    protected boolean lastEnchanted = false;
    protected String lastLore = null;
    protected String lastItemName = null;
    protected String lastNbtData = null;
    protected final class_327 font;

    public ItemElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        this.font = class_310.method_1551().field_1772;
        this.supportsTilting = false;
    }

    protected void updateCachedItem() {
        String keyFinal = PlaceholderParser.replacePlaceholders(this.itemKey);
        String loreFinal = this.lore == null ? null : PlaceholderParser.replacePlaceholders(this.lore);
        String nameFinal = this.itemName == null ? null : PlaceholderParser.replacePlaceholders(this.itemName);
        String nbtFinal = this.nbtData == null ? null : PlaceholderParser.replacePlaceholders(this.nbtData);
        try {
            if (!(this.cachedStack != null && keyFinal.equals(this.lastItemKey) && this.enchanted == this.lastEnchanted && Objects.equals(loreFinal, this.lastLore) && Objects.equals(nameFinal, this.lastItemName) && Objects.equals(nbtFinal, this.lastNbtData))) {
                class_9326 nbt;
                Optional optional = class_7923.field_41178.method_10223(class_2960.method_60654((String)keyFinal));
                class_1792 item = optional.isPresent() ? Objects.requireNonNullElse((class_1792)((class_6880.class_6883)optional.get()).comp_349(), class_1802.field_8162) : class_1802.field_8162;
                this.cachedStack = new class_1799((class_1935)item);
                this.cachedStack.method_57379(class_9334.field_49641, (Object)this.enchanted);
                if (loreFinal != null && !loreFinal.isBlank()) {
                    ArrayList<class_2561> lines = new ArrayList<class_2561>();
                    for (String line : StringUtils.splitLines((String)loreFinal.replace("%n%", "\n"), (String)"\n")) {
                        lines.add(ItemElement.buildComponent(line));
                    }
                    this.cachedStack.method_57379(class_9334.field_49632, (Object)new class_9290(lines));
                }
                if (nameFinal != null) {
                    this.cachedStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)nameFinal));
                }
                if (nbtFinal != null && (nbt = NBTBuilder.buildNbtFromString(this.cachedStack, nbtFinal)) != null) {
                    this.cachedStack.method_57366(nbt);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to create ItemStack instance for 'Item' element!", (Throwable)ex);
            this.cachedStack = new class_1799((class_1935)class_1802.field_8077);
        }
        this.lastItemKey = keyFinal;
        this.lastEnchanted = this.enchanted;
        this.lastLore = loreFinal;
        this.lastItemName = nameFinal;
        this.lastNbtData = nbtFinal;
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.shouldRender()) {
            this.updateCachedItem();
            if (this.cachedStack != null) {
                int x = this.getAbsoluteX();
                int y = this.getAbsoluteY();
                int w = this.getAbsoluteWidth();
                int h = this.getAbsoluteHeight();
                this.renderItem(graphics, x, y, w, h, mouseX, mouseY, this.cachedStack);
            }
        }
    }

    protected void renderItem(class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY, @NotNull class_1799 itemStack) {
        int count = SerializationUtils.deserializeNumber(Integer.class, 1, PlaceholderParser.replacePlaceholders(this.itemCount));
        this.renderScaledItem(graphics, itemStack, x, y, width, height);
        if (count > 1) {
            this.renderItemCount(graphics, this.font, x, y, Math.max(width, height), count);
        }
        if (!ItemElement.isEditor() && this.showTooltip && UIBase.isXYInArea(mouseX, mouseY, this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteWidth(), this.getAbsoluteHeight())) {
            this.renderItemTooltip(graphics, mouseX, mouseY, itemStack);
        }
    }

    @NotNull
    protected List<class_2561> buildItemTooltip(@NotNull class_1799 itemStack) {
        return itemStack.method_7950(class_1792.class_9635.field_51353, null, (class_1836)class_1836.field_41070);
    }

    protected void renderItemTooltip(@NotNull class_332 graphics, int mouseX, int mouseY, @NotNull class_1799 itemStack) {
        graphics.method_64038(this.font, class_437.method_25408((class_310)class_310.method_1551(), (class_1799)itemStack), itemStack.method_32347(), mouseX, mouseY);
    }

    protected void renderScaledItem(@NotNull class_332 graphics, @NotNull class_1799 stack, int x, int y, int width, int height) {
        graphics.method_51448().pushMatrix();
        graphics.method_51448().translate((float)x, (float)y);
        float scale = (float)Math.min(width, height) / 16.0f;
        graphics.method_51448().scale(scale, scale);
        graphics.method_51427(stack, 0, 0);
        graphics.method_51448().popMatrix();
    }

    protected void renderItemCount(@NotNull class_332 graphics, @NotNull class_327 font, int x, int y, int size, int count) {
        String text = String.valueOf(count);
        float scaleFactor = (float)size / 16.0f;
        graphics.method_51448().pushMatrix();
        float textX = 17 - font.method_1727(text);
        float textY = 9.0f;
        graphics.method_51448().translate((float)x, (float)y);
        graphics.method_51448().scale(scaleFactor, scaleFactor);
        graphics.method_51433(font, text, (int)textX, (int)textY, -1, true);
        graphics.method_51448().popMatrix();
    }
}

