/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.tooltip;

import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.element.editor.EditorElementSettings;
import de.keksuccino.fancymenu.customization.element.elements.tooltip.TooltipElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.text.markdown.MarkdownRenderer;
import de.keksuccino.fancymenu.util.rendering.ui.contextmenu.v2.ContextMenu;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorScreen;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class TooltipEditorElement
extends AbstractEditorElement {
    public TooltipEditorElement(@NotNull TooltipElement element, @NotNull LayoutEditorScreen editor) {
        super(element, editor, new EditorElementSettings(){
            {
                this.setResizeableX(true);
                this.setResizeableY(false);
                this.setParallaxAllowed(false);
                this.setAutoSizingAllowed(false);
                this.setStretchable(false);
                this.setAdvancedSizingSupported(false);
                this.setDelayable(false);
                this.setFadeable(false);
                this.setStayOnScreenAllowed(false);
                this.setOpacityChangeable(false);
            }
        });
    }

    @Override
    public void init() {
        super.init();
        TooltipElement tooltipElement = (TooltipElement)this.element;
        ContextMenu contentMenu = new ContextMenu();
        this.rightClickMenu.addSubMenuEntry("content", (class_2561)class_2561.method_43471((String)"fancymenu.elements.tooltip.content"), contentMenu).setIcon(ContextMenu.IconFactory.getIcon("text"));
        this.addCycleContextMenuEntryTo(contentMenu, "source_mode", List.of(TooltipElement.SourceMode.DIRECT, TooltipElement.SourceMode.RESOURCE), TooltipEditorElement.class, e -> e.getElement().sourceMode, (e, mode) -> e.getElement().setSource((TooltipElement.SourceMode)mode, null), (menu, entry, value) -> value.getCycleComponent()).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.text.v2.source_mode.desc", new String[0])));
        ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)contentMenu.addClickableEntry("set_text", (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.v2.source.input"), (menu, entry) -> {
            if (entry.getStackMeta().isFirstInStack()) {
                List<AbstractEditorElement> selectedElements = this.getFilteredSelectedElementList(e -> e instanceof TooltipEditorElement);
                String defaultText = tooltipElement.source;
                TextEditorScreen s = new TextEditorScreen((class_2561)class_2561.method_43471((String)"fancymenu.elements.text.v2.source.input"), null, call -> {
                    if (call != null) {
                        this.editor.history.saveSnapshot();
                        for (AbstractEditorElement e : selectedElements) {
                            ((TooltipElement)e.element).setSource(TooltipElement.SourceMode.DIRECT, (String)call);
                        }
                    }
                    class_310.method_1551().method_1507((class_437)this.editor);
                });
                s.setText(defaultText);
                s.setMultilineMode(true);
                s.setPlaceholdersAllowed(true);
                class_310.method_1551().method_1507((class_437)s);
            }
        }).setStackable(true)).setIsActiveSupplier((menu, entry) -> tooltipElement.sourceMode == TooltipElement.SourceMode.DIRECT)).setIcon(ContextMenu.IconFactory.getIcon("text"));
        this.addTextResourceChooserContextMenuEntryTo(contentMenu, "set_resource", TooltipEditorElement.class, null, e -> ((TooltipElement)e.element).textResourceSupplier, (e, supplier) -> {
            TooltipElement el = (TooltipElement)e.element;
            el.textResourceSupplier = supplier;
            el.setSource(TooltipElement.SourceMode.RESOURCE, supplier != null ? supplier.getSourceWithPrefix() : null);
        }, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.v2.source.choose"), true, null, true, true, true).setIsActiveSupplier((menu, entry) -> tooltipElement.sourceMode == TooltipElement.SourceMode.RESOURCE);
        ContextMenu markdownMenu = new ContextMenu();
        this.rightClickMenu.addSubMenuEntry("markdown", (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.markdown"), markdownMenu).setIcon(ContextMenu.IconFactory.getIcon("text"));
        this.addToggleContextMenuEntryTo(markdownMenu, "text_shadow", TooltipEditorElement.class, e -> ((TooltipElement)e.element).markdownRenderer.isTextShadow(), (e, value) -> ((TooltipElement)e.element).markdownRenderer.setTextShadow((boolean)value), "fancymenu.elements.text.shadow");
        this.addCycleContextMenuEntryTo(markdownMenu, "text_case", List.of(MarkdownRenderer.TextCase.NORMAL, MarkdownRenderer.TextCase.ALL_LOWER, MarkdownRenderer.TextCase.ALL_UPPER), TooltipEditorElement.class, e -> ((TooltipElement)e.element).markdownRenderer.getTextCase(), (e, caseMode) -> ((TooltipElement)e.element).markdownRenderer.setTextCase((MarkdownRenderer.TextCase)((Object)caseMode)), (menu, entry, value) -> {
            if (value == MarkdownRenderer.TextCase.NORMAL) {
                return class_2561.method_43471((String)"fancymenu.elements.text.case_mode.normal");
            }
            if (value == MarkdownRenderer.TextCase.ALL_LOWER) {
                return class_2561.method_43471((String)"fancymenu.elements.text.case_mode.lower");
            }
            return class_2561.method_43471((String)"fancymenu.elements.text.case_mode.upper");
        });
        this.addFloatInputContextMenuEntryTo(markdownMenu, "text_scale", TooltipEditorElement.class, e -> Float.valueOf(((TooltipElement)e.element).markdownRenderer.getTextBaseScale()), (e, scale) -> ((TooltipElement)e.element).markdownRenderer.setTextBaseScale(scale.floatValue()), (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.scale"), true, 1.0f, null, null);
        this.addStringInputContextMenuEntryTo(markdownMenu, "text_color", TooltipEditorElement.class, e -> ((TooltipElement)e.element).markdownRenderer.getTextBaseColor().getHex(), (e, color) -> ((TooltipElement)e.element).markdownRenderer.setTextBaseColor(DrawableColor.of(color)), null, false, false, (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.base_color"), true, "#FFFFFF", null, null);
        this.addIntegerInputContextMenuEntryTo(markdownMenu, "text_border", TooltipEditorElement.class, e -> (int)((TooltipElement)e.element).markdownRenderer.getBorder(), (e, border) -> ((TooltipElement)e.element).markdownRenderer.setBorder(border.intValue()), (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.text_border"), true, 0, null, null);
        this.addIntegerInputContextMenuEntryTo(markdownMenu, "line_spacing", TooltipEditorElement.class, e -> (int)((TooltipElement)e.element).markdownRenderer.getLineSpacing(), (e, spacing) -> ((TooltipElement)e.element).markdownRenderer.setLineSpacing(spacing.intValue()), (class_2561)class_2561.method_43471((String)"fancymenu.elements.text.line_spacing"), true, 1, null, null);
        this.addToggleContextMenuEntryTo(markdownMenu, "auto_line_wrapping", TooltipEditorElement.class, e -> ((TooltipElement)e.element).markdownRenderer.isAutoLineBreakingEnabled(), (e, value) -> ((TooltipElement)e.element).markdownRenderer.setAutoLineBreakingEnabled((boolean)value), "fancymenu.elements.text.auto_line_wrapping");
        this.addToggleContextMenuEntryTo(markdownMenu, "parse_markdown", TooltipEditorElement.class, e -> ((TooltipElement)e.element).markdownRenderer.isParseMarkdown(), (e, value) -> ((TooltipElement)e.element).markdownRenderer.setParseMarkdown((boolean)value), "fancymenu.elements.text.markdown.toggle");
        this.rightClickMenu.addSeparatorEntry("separator_after_markdown");
        ContextMenu backgroundMenu = new ContextMenu();
        this.rightClickMenu.addSubMenuEntry("background", (class_2561)class_2561.method_43471((String)"fancymenu.elements.tooltip.background"), backgroundMenu).setIcon(ContextMenu.IconFactory.getIcon("image"));
        ((ContextMenu.ClickableContextMenuEntry)this.addImageResourceChooserContextMenuEntryTo(backgroundMenu, "background_texture", TooltipEditorElement.class, null, e -> ((TooltipElement)e.element).backgroundTexture, (e, texture) -> {
            ((TooltipElement)e.element).backgroundTexture = texture;
        }, (class_2561)class_2561.method_43471((String)"fancymenu.elements.tooltip.background_texture"), true, null, true, true, true).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.tooltip.background_texture.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("image"));
        ContextMenu nineSliceMenu = new ContextMenu();
        ((ContextMenu.SubMenuContextMenuEntry)backgroundMenu.addSubMenuEntry("nine_slice", (class_2561)class_2561.method_43471((String)"fancymenu.elements.tooltip.nine_slice"), nineSliceMenu).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.tooltip.nine_slice.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("measure"));
        this.addIntegerInputContextMenuEntryTo(nineSliceMenu, "nine_slice_border_top", TooltipEditorElement.class, e -> ((TooltipElement)e.element).nineSliceBorderTop, (e, value) -> {
            ((TooltipElement)e.element).nineSliceBorderTop = value;
        }, (class_2561)class_2561.method_43471((String)"fancymenu.elements.tooltip.nine_slice.border.top"), true, 5, null, null);
        this.addIntegerInputContextMenuEntryTo(nineSliceMenu, "nine_slice_border_right", TooltipEditorElement.class, e -> ((TooltipElement)e.element).nineSliceBorderRight, (e, value) -> {
            ((TooltipElement)e.element).nineSliceBorderRight = value;
        }, (class_2561)class_2561.method_43471((String)"fancymenu.elements.tooltip.nine_slice.border.right"), true, 5, null, null);
        this.addIntegerInputContextMenuEntryTo(nineSliceMenu, "nine_slice_border_bottom", TooltipEditorElement.class, e -> ((TooltipElement)e.element).nineSliceBorderBottom, (e, value) -> {
            ((TooltipElement)e.element).nineSliceBorderBottom = value;
        }, (class_2561)class_2561.method_43471((String)"fancymenu.elements.tooltip.nine_slice.border.bottom"), true, 5, null, null);
        this.addIntegerInputContextMenuEntryTo(nineSliceMenu, "nine_slice_border_left", TooltipEditorElement.class, e -> ((TooltipElement)e.element).nineSliceBorderLeft, (e, value) -> {
            ((TooltipElement)e.element).nineSliceBorderLeft = value;
        }, (class_2561)class_2561.method_43471((String)"fancymenu.elements.tooltip.nine_slice.border.left"), true, 5, null, null);
        this.addToggleContextMenuEntryTo(this.rightClickMenu, "mouse_following", TooltipEditorElement.class, e -> ((TooltipElement)e.element).mouseFollowing, (e, value) -> {
            ((TooltipElement)e.element).mouseFollowing = value;
        }, "fancymenu.elements.tooltip.mouse_following").setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.tooltip.mouse_following.desc", new String[0])));
    }

    @NotNull
    public TooltipElement getElement() {
        return (TooltipElement)this.element;
    }
}

