/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.gui;

import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.customization.action.Executable;
import de.keksuccino.fancymenu.customization.action.blocks.AbstractExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.GenericExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.statements.ElseExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.statements.ElseIfExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.statements.IfExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.statements.WhileExecutableBlock;
import de.keksuccino.fancymenu.customization.action.ui.ActionScriptEditorScreen;
import de.keksuccino.fancymenu.customization.listener.ListenerHandler;
import de.keksuccino.fancymenu.customization.listener.ListenerInstance;
import de.keksuccino.fancymenu.customization.listener.gui.ChooseListenerTypeScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementGroup;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.cursor.CursorHandler;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.konkrete.input.MouseInput;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageListenersScreen
extends CellScreen {
    @NotNull
    protected final Consumer<Boolean> callback;
    @NotNull
    protected final List<ListenerInstance> tempInstances = new ArrayList<ListenerInstance>();
    @Nullable
    protected ListenerInstance selectedInstance;

    public ManageListenersScreen(@NotNull Consumer<Boolean> callback) {
        super((class_2561)class_2561.method_43471((String)"fancymenu.listeners.manage"));
        this.callback = callback;
        this.tempInstances.addAll(ListenerHandler.getInstances());
        this.setSearchBarEnabled(true);
        this.setDescriptionAreaEnabled(true);
    }

    @Override
    protected void initCells() {
        String editingInstanceId = null;
        String editingValue = null;
        for (Object cell2 : this.allCells) {
            if (!(cell2 instanceof ListenerInstanceCell)) continue;
            ListenerInstanceCell instanceCell = (ListenerInstanceCell)cell2;
            if (!instanceCell.editMode || instanceCell.editBox == null) continue;
            editingInstanceId = instanceCell.instance.instanceIdentifier;
            editingValue = instanceCell.editBox.method_1882();
            break;
        }
        this.addSpacerCell(5).setIgnoreSearch();
        ArrayList<ListenerInstanceCell> instanceCells = new ArrayList<ListenerInstanceCell>();
        for (ListenerInstance instance : this.tempInstances) {
            ListenerInstanceCell cell3 = new ListenerInstanceCell(instance);
            instanceCells.add(cell3);
        }
        instanceCells.sort(Comparator.comparing(cell -> cell.labelComponent.getString(), String.CASE_INSENSITIVE_ORDER).thenComparing(cell -> cell.labelComponent.getString()).thenComparing(cell -> cell.instance.instanceIdentifier));
        String finalEditingInstanceId = editingInstanceId;
        String finalEditingValue = editingValue;
        instanceCells.forEach(cell -> {
            this.addCell(cell).setSelectable(true);
            if (finalEditingInstanceId != null && finalEditingInstanceId.equals(cell.instance.instanceIdentifier)) {
                cell.enterEditMode();
                if (cell.editBox != null && finalEditingValue != null) {
                    cell.editBox.method_1852(finalEditingValue);
                    cell.editBox.method_1875(finalEditingValue.length());
                }
            }
        });
        this.addSpacerCell(5).setIgnoreSearch();
    }

    @Override
    protected void initRightSideWidgets() {
        this.addRightSideButton(20, (class_2561)class_2561.method_43471((String)"fancymenu.listeners.manage.add"), button -> {
            ChooseListenerTypeScreen chooseScreen = new ChooseListenerTypeScreen(listener -> {
                if (listener != null) {
                    ListenerInstance newInstance = listener.createFreshInstance();
                    ActionScriptEditorScreen actionsScreen = new ActionScriptEditorScreen(newInstance.getActionScript(), updatedScript -> {
                        if (updatedScript != null) {
                            newInstance.setActionScript((GenericExecutableBlock)updatedScript);
                            this.tempInstances.add(newInstance);
                            this.rebuild();
                        }
                        class_310.method_1551().method_1507((class_437)this);
                    });
                    class_310.method_1551().method_1507((class_437)actionsScreen);
                } else {
                    class_310.method_1551().method_1507((class_437)this);
                }
            });
            class_310.method_1551().method_1507((class_437)chooseScreen);
        });
        this.addRightSideButton(20, (class_2561)class_2561.method_43471((String)"fancymenu.listeners.manage.edit"), button -> this.onEditActionsOfSelected()).setIsActiveSupplier(consumes -> this.selectedInstance != null);
        this.addRightSideButton(20, (class_2561)class_2561.method_43471((String)"fancymenu.listeners.manage.remove"), button -> {
            ListenerInstance sel = this.selectedInstance;
            if (sel != null) {
                class_310.method_1551().method_1507((class_437)ConfirmationScreen.critical(call -> {
                    if (call.booleanValue()) {
                        this.tempInstances.remove(sel);
                        this.selectedInstance = null;
                        this.rebuild();
                    }
                    class_310.method_1551().method_1507((class_437)this);
                }, new class_2561[]{class_2561.method_43471((String)"fancymenu.listeners.manage.delete_warning")}));
            }
        }).setIsActiveSupplier(consumes -> this.selectedInstance != null);
    }

    protected void onEditActionsOfSelected() {
        if (this.selectedInstance != null) {
            ListenerInstance cached = this.selectedInstance;
            ActionScriptEditorScreen actionsScreen = new ActionScriptEditorScreen(cached.getActionScript(), updatedScript -> {
                if (updatedScript != null) {
                    cached.setActionScript((GenericExecutableBlock)updatedScript);
                }
                class_310.method_1551().method_1507((class_437)this);
            });
            class_310.method_1551().method_1507((class_437)actionsScreen);
        }
    }

    @Override
    @Nullable
    protected List<class_2561> getCurrentDescription() {
        this.updateSelectedInstance();
        List<class_2561> desc = super.getCurrentDescription();
        if (desc == null) {
            return null;
        }
        if (this.selectedInstance == null) {
            return null;
        }
        ArrayList<class_2561> newDesc = new ArrayList<class_2561>();
        newDesc.add((class_2561)class_2561.method_43471((String)"fancymenu.listeners.manage.description.listener_desc").method_27692(class_124.field_1067));
        newDesc.add((class_2561)class_2561.method_43470((String)"(").method_10852(this.selectedInstance.parent.getDisplayName()).method_27693(")"));
        newDesc.add((class_2561)class_2561.method_43473());
        newDesc.addAll(desc);
        newDesc.add((class_2561)class_2561.method_43473());
        newDesc.add((class_2561)class_2561.method_43473());
        newDesc.add((class_2561)class_2561.method_43471((String)"fancymenu.listeners.manage.description.actions").method_27692(class_124.field_1067));
        newDesc.add((class_2561)class_2561.method_43473());
        List<class_2561> actionLines = this.buildActionScriptDescription(this.selectedInstance.getActionScript(), 0);
        newDesc.addAll(actionLines);
        return newDesc;
    }

    public boolean method_25422() {
        return false;
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.updateSelectedInstance();
        super.method_25394(graphics, mouseX, mouseY, partial);
        if (this.descriptionScrollArea != null) {
            int lineX;
            int lineWidth;
            int descW = (int)this.descriptionScrollArea.getWidthWithBorder();
            int descEndX = (int)(this.descriptionScrollArea.getXWithBorder() + this.descriptionScrollArea.getWidthWithBorder());
            int descEndY = (int)(this.descriptionScrollArea.getYWithBorder() + this.descriptionScrollArea.getHeightWithBorder());
            List renameTip = this.field_22793.method_1728((class_5348)class_2561.method_43471((String)"fancymenu.listeners.manage.rename_tip").method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_inactive.getColorInt()).method_10978(Boolean.valueOf(true))), descW);
            List quickEditTip = this.field_22793.method_1728((class_5348)class_2561.method_43471((String)"fancymenu.listeners.manage.quick_edit_tip").method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_inactive.getColorInt()).method_10978(Boolean.valueOf(true))), descW);
            int lineY = descEndY + 4;
            for (class_5481 line : renameTip) {
                lineWidth = this.field_22793.method_30880(line);
                lineX = descEndX - lineWidth;
                graphics.method_51430(this.field_22793, line, lineX, lineY, -1, false);
                Objects.requireNonNull(this.field_22793);
                lineY += 9 + 2;
            }
            lineY += 2;
            for (class_5481 line : quickEditTip) {
                lineWidth = this.field_22793.method_30880(line);
                lineX = descEndX - lineWidth;
                graphics.method_51430(this.field_22793, line, lineX, lineY, -1, false);
                Objects.requireNonNull(this.field_22793);
                lineY += 9 + 2;
            }
        }
    }

    @Override
    protected void onCancel() {
        class_310.method_1551().method_1507((class_437)ConfirmationScreen.critical(callback -> {
            if (callback.booleanValue()) {
                this.callback.accept(false);
            } else {
                class_310.method_1551().method_1507((class_437)this);
            }
        }, new class_2561[]{class_2561.method_43471((String)"fancymenu.listeners.manage.cancel_warning")}));
    }

    @Override
    protected void onDone() {
        for (ListenerInstance instance : new ArrayList<ListenerInstance>(ListenerHandler.getInstances())) {
            ListenerHandler.removeInstance(instance.instanceIdentifier);
        }
        for (ListenerInstance instance : this.tempInstances) {
            ListenerHandler.addInstance(instance);
        }
        this.callback.accept(true);
    }

    protected void updateSelectedInstance() {
        this.updateSelectedCell();
        CellScreen.RenderCell selected = this.getSelectedCell();
        if (selected instanceof ListenerInstanceCell) {
            ListenerInstanceCell cell = (ListenerInstanceCell)selected;
            this.selectedInstance = cell.instance;
        } else {
            this.selectedInstance = null;
        }
    }

    @NotNull
    protected List<class_2561> buildActionScriptDescription(@NotNull GenericExecutableBlock block, int indentLevel) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        for (Executable executable : block.getExecutables()) {
            lines.addAll(this.buildExecutableDescription(executable, indentLevel));
        }
        if (lines.isEmpty()) {
            String indent = "  ".repeat(Math.max(0, indentLevel));
            lines.add((class_2561)class_2561.method_43470((String)(indent + "\u2022 ")).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().listing_dot_color_1.getColorInt())).method_10852((class_2561)class_2561.method_43471((String)"fancymenu.actions.screens.manage_screen.info.value.none").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt()))));
        }
        return lines;
    }

    @NotNull
    protected List<class_2561> buildExecutableDescription(@NotNull Executable executable, int indentLevel) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        String indent = "  ".repeat(Math.max(0, indentLevel));
        if (executable instanceof ActionInstance) {
            ActionInstance actionInstance = (ActionInstance)executable;
            lines.add((class_2561)class_2561.method_43470((String)(indent + "\u2022 ")).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().listing_dot_color_2.getColorInt())).method_10852((class_2561)actionInstance.action.getActionDisplayName().method_27661().method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()))));
            String cachedValue = actionInstance.value;
            String valueString = cachedValue != null && actionInstance.action.hasValue() ? cachedValue : class_1074.method_4662((String)"fancymenu.actions.screens.manage_screen.info.value.none", (Object[])new Object[0]);
            lines.add((class_2561)class_2561.method_43470((String)(indent + "    \u25e6 ")).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().listing_dot_color_1.getColorInt())).method_10852((class_2561)class_2561.method_43470((String)(class_1074.method_4662((String)"fancymenu.actions.screens.manage_screen.info.value", (Object[])new Object[0]) + " ")).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt()))).method_10852((class_2561)class_2561.method_43470((String)valueString).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()))));
        } else if (executable instanceof IfExecutableBlock) {
            IfExecutableBlock ifBlock = (IfExecutableBlock)executable;
            String requirements = this.buildRequirementsString(ifBlock);
            lines.add((class_2561)class_2561.method_43470((String)(indent + "\u2022 ")).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt())).method_10852((class_2561)class_2561.method_43469((String)"fancymenu.actions.blocks.if", (Object[])new Object[]{class_2561.method_43470((String)requirements)}).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()))));
            for (Executable nested : ifBlock.getExecutables()) {
                lines.addAll(this.buildExecutableDescription(nested, indentLevel + 1));
            }
            for (AbstractExecutableBlock appended = ifBlock.getAppendedBlock(); appended != null; appended = appended.getAppendedBlock()) {
                lines.addAll(this.buildAppendedBlockDescription(appended, indentLevel));
            }
        } else if (executable instanceof WhileExecutableBlock) {
            WhileExecutableBlock whileBlock = (WhileExecutableBlock)executable;
            String requirements = this.buildRequirementsString(whileBlock);
            lines.add((class_2561)class_2561.method_43470((String)(indent + "\u2022 ")).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt())).method_10852((class_2561)class_2561.method_43469((String)"fancymenu.actions.blocks.while", (Object[])new Object[]{class_2561.method_43470((String)requirements)}).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()))));
            for (Executable nested : whileBlock.getExecutables()) {
                lines.addAll(this.buildExecutableDescription(nested, indentLevel + 1));
            }
        } else if (executable instanceof AbstractExecutableBlock) {
            lines.add((class_2561)class_2561.method_43470((String)(indent + "\u2022 ")).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt())).method_10852((class_2561)class_2561.method_43470((String)"[UNKNOWN BLOCK]").method_10862(class_2583.field_24360.method_10977(class_124.field_1061))));
        }
        return lines;
    }

    @NotNull
    protected List<class_2561> buildAppendedBlockDescription(@NotNull AbstractExecutableBlock block, int indentLevel) {
        ArrayList<class_2561> lines;
        block3: {
            String indent;
            block2: {
                lines = new ArrayList<class_2561>();
                indent = "  ".repeat(Math.max(0, indentLevel));
                if (!(block instanceof ElseIfExecutableBlock)) break block2;
                ElseIfExecutableBlock elseIfBlock = (ElseIfExecutableBlock)block;
                String requirements = this.buildRequirementsString(elseIfBlock);
                lines.add((class_2561)class_2561.method_43470((String)(indent + "\u2022 ")).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt())).method_10852((class_2561)class_2561.method_43469((String)"fancymenu.actions.blocks.else_if", (Object[])new Object[]{class_2561.method_43470((String)requirements)}).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()))));
                for (Executable nested : elseIfBlock.getExecutables()) {
                    lines.addAll(this.buildExecutableDescription(nested, indentLevel + 1));
                }
                break block3;
            }
            if (!(block instanceof ElseExecutableBlock)) break block3;
            ElseExecutableBlock elseBlock = (ElseExecutableBlock)block;
            lines.add((class_2561)class_2561.method_43470((String)(indent + "\u2022 ")).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt())).method_10852((class_2561)class_2561.method_43471((String)"fancymenu.actions.blocks.else").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()))));
            for (Executable nested : elseBlock.getExecutables()) {
                lines.addAll(this.buildExecutableDescription(nested, indentLevel + 1));
            }
        }
        return lines;
    }

    @NotNull
    protected String buildRequirementsString(@NotNull IfExecutableBlock block) {
        Object requirements = "";
        for (LoadingRequirementGroup g : block.condition.getGroups()) {
            if (!((String)requirements).isEmpty()) {
                requirements = (String)requirements + ", ";
            }
            requirements = (String)requirements + g.identifier;
        }
        for (LoadingRequirementInstance i : block.condition.getInstances()) {
            if (!((String)requirements).isEmpty()) {
                requirements = (String)requirements + ", ";
            }
            requirements = (String)requirements + i.requirement.getDisplayName();
        }
        return ((String)requirements).isEmpty() ? "none" : requirements;
    }

    @NotNull
    protected String buildRequirementsString(@NotNull ElseIfExecutableBlock block) {
        Object requirements = "";
        for (LoadingRequirementGroup g : block.condition.getGroups()) {
            if (!((String)requirements).isEmpty()) {
                requirements = (String)requirements + ", ";
            }
            requirements = (String)requirements + g.identifier;
        }
        for (LoadingRequirementInstance i : block.condition.getInstances()) {
            if (!((String)requirements).isEmpty()) {
                requirements = (String)requirements + ", ";
            }
            requirements = (String)requirements + i.requirement.getDisplayName();
        }
        return ((String)requirements).isEmpty() ? "none" : requirements;
    }

    @NotNull
    protected String buildRequirementsString(@NotNull WhileExecutableBlock block) {
        Object requirements = "";
        for (LoadingRequirementGroup g : block.condition.getGroups()) {
            if (!((String)requirements).isEmpty()) {
                requirements = (String)requirements + ", ";
            }
            requirements = (String)requirements + g.identifier;
        }
        for (LoadingRequirementInstance i : block.condition.getInstances()) {
            if (!((String)requirements).isEmpty()) {
                requirements = (String)requirements + ", ";
            }
            requirements = (String)requirements + i.requirement.getDisplayName();
        }
        return ((String)requirements).isEmpty() ? "none" : requirements;
    }

    public class ListenerInstanceCell
    extends CellScreen.RenderCell {
        @NotNull
        protected final ListenerInstance instance;
        @NotNull
        protected class_2561 labelComponent;
        @Nullable
        protected ExtendedEditBox editBox;
        protected boolean editMode;
        protected long lastClickTime;
        protected static final long DOUBLE_CLICK_TIME = 500L;
        protected static final int TOP_DOWN_CELL_BORDER = 1;

        public ListenerInstanceCell(ListenerInstance instance) {
            super(ManageListenersScreen.this);
            this.editMode = false;
            this.lastClickTime = 0L;
            this.instance = instance;
            this.updateLabelComponent();
            this.setDescriptionSupplier(this.instance.parent::getDescription);
            this.setSearchStringSupplier(() -> {
                if (this.instance.getDisplayName() != null) {
                    return this.instance.getDisplayName();
                }
                return this.instance.parent.getDisplayName().getString();
            });
        }

        protected void updateLabelComponent() {
            this.labelComponent = this.instance.getDisplayName() != null && !this.instance.getDisplayName().isBlank() ? class_2561.method_43470((String)this.instance.getDisplayName()).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt())) : this.instance.parent.getDisplayName().method_27661().method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()));
        }

        @Override
        public void renderCell(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            if (this.editMode && this.editBox != null) {
                this.editBox.method_46421(this.getX());
                this.editBox.method_46419(this.getY() + 1);
                this.editBox.method_25358(Math.min(this.getWidth(), 200));
                Objects.requireNonNull(class_310.method_1551().field_1772);
                this.editBox.method_53533(9 + 1);
                this.editBox.method_25394(graphics, mouseX, mouseY, partial);
                if (MouseInput.isLeftMouseDown() && !this.editBox.method_49606()) {
                    this.exitEditMode(true);
                }
            } else {
                UIBase.drawElementLabel(graphics, class_310.method_1551().field_1772, this.labelComponent, this.getX(), this.getY() + 1);
                int n = this.getX();
                int n2 = this.getY() + 1;
                int n3 = class_310.method_1551().field_1772.method_27525((class_5348)this.labelComponent);
                Objects.requireNonNull(class_310.method_1551().field_1772);
                if (UIBase.isXYInArea(mouseX, mouseY, n, n2, n3, 9)) {
                    CursorHandler.setClientTickCursor(CursorHandler.CURSOR_WRITING);
                }
            }
        }

        @Override
        protected void updateSize(@NotNull CellScreen.CellScrollEntry scrollEntry) {
            if (this.editMode && this.editBox != null) {
                this.setWidth(Math.min((int)(ManageListenersScreen.this.scrollArea.getInnerWidth() - 40.0f), 200));
            } else {
                this.setWidth(class_310.method_1551().field_1772.method_27525((class_5348)this.labelComponent));
            }
            Objects.requireNonNull(class_310.method_1551().field_1772);
            this.setHeight(9 + 2);
        }

        @Override
        public boolean method_25402(class_11909 event, boolean isDoubleClick) {
            if (event.method_74245() == 0 && this.isHovered() && !this.editMode) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastClickTime < 500L) {
                    this.enterEditMode();
                    this.lastClickTime = 0L;
                } else {
                    this.lastClickTime = currentTime;
                }
            }
            boolean b = super.method_25402(event, isDoubleClick);
            if (event.method_74245() == 1 && this.isHovered() && !this.editMode) {
                MainThreadTaskExecutor.executeInMainThread(() -> MainThreadTaskExecutor.executeInMainThread(() -> {
                    this.setSelected(true);
                    ManageListenersScreen.this.updateSelectedInstance();
                    ManageListenersScreen.this.onEditActionsOfSelected();
                }, MainThreadTaskExecutor.ExecuteTiming.PRE_CLIENT_TICK), MainThreadTaskExecutor.ExecuteTiming.PRE_CLIENT_TICK);
            }
            return b;
        }

        public boolean method_25404(@NotNull class_11908 event) {
            if (this.editMode && this.editBox != null) {
                if (event.comp_4795() == 257 || event.comp_4795() == 335) {
                    this.exitEditMode(true);
                    return true;
                }
                if (event.comp_4795() == 256) {
                    this.exitEditMode(false);
                    return true;
                }
                return this.editBox.method_25404(event);
            }
            return super.method_25404(event);
        }

        public boolean method_25400(@NotNull class_11905 event) {
            if (this.editMode && this.editBox != null) {
                return this.editBox.method_25400(event);
            }
            return super.method_25400(event);
        }

        protected void enterEditMode() {
            if (this.editMode) {
                return;
            }
            this.editMode = true;
            this.editBox = new ExtendedEditBox(class_310.method_1551().field_1772, this.getX(), this.getY(), Math.min(200, (int)(ManageListenersScreen.this.scrollArea.getInnerWidth() - 40.0f)), 18, (class_2561)class_2561.method_43473());
            UIBase.applyDefaultWidgetSkinTo(this.editBox);
            this.editBox.method_1880(100000);
            String currentName = this.instance.getDisplayName();
            if (currentName != null) {
                this.editBox.method_1852(currentName);
            } else {
                this.editBox.method_1852("");
            }
            this.editBox.method_25365(true);
            this.editBox.method_1875(this.editBox.method_1882().length());
            this.editBox.method_1884(0);
            this.children.clear();
            this.children.add(this.editBox);
        }

        protected void exitEditMode(boolean save) {
            if (!this.editMode || this.editBox == null) {
                return;
            }
            if (save) {
                String newName = this.editBox.method_1882();
                if (newName.isBlank()) {
                    this.instance.setDisplayName(null);
                } else {
                    this.instance.setDisplayName(newName);
                }
                this.updateLabelComponent();
                if (ManageListenersScreen.this.selectedInstance == this.instance) {
                    ManageListenersScreen.this.updateDescriptionArea();
                }
            }
            this.editMode = false;
            this.editBox = null;
            this.children.clear();
        }
    }
}

