/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnStartLookingAtBlockListener
extends AbstractListener {
    public static final double MAX_LOOK_DISTANCE = 20.0;
    @Nullable
    private LookedBlockData currentBlockData;

    public OnStartLookingAtBlockListener() {
        super("start_looking_at_block");
    }

    public boolean onLookAtBlock(@NotNull class_638 level, @NotNull class_3965 hitResult, double distance) {
        LookedBlockData newData = LookedBlockData.from(level, hitResult, distance);
        LookedBlockData existingData = this.currentBlockData;
        if (existingData != null && existingData.isSameTarget(newData)) {
            this.currentBlockData = newData;
            return false;
        }
        this.currentBlockData = newData;
        this.notifyAllInstances();
        return true;
    }

    public void clearCurrentBlock() {
        this.currentBlockData = null;
    }

    @Nullable
    public LookedBlockData getCurrentBlockData() {
        return this.currentBlockData;
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("block_key", () -> {
            LookedBlockData data = this.currentBlockData;
            if (data == null || data.blockKey() == null) {
                return "ERROR";
            }
            return data.blockKey();
        }));
        list.add(new AbstractListener.CustomVariable("block_pos_x", () -> {
            LookedBlockData data = this.currentBlockData;
            if (data == null) {
                return "0";
            }
            return Integer.toString(data.blockPos().method_10263());
        }));
        list.add(new AbstractListener.CustomVariable("block_pos_y", () -> {
            LookedBlockData data = this.currentBlockData;
            if (data == null) {
                return "0";
            }
            return Integer.toString(data.blockPos().method_10264());
        }));
        list.add(new AbstractListener.CustomVariable("block_pos_z", () -> {
            LookedBlockData data = this.currentBlockData;
            if (data == null) {
                return "0";
            }
            return Integer.toString(data.blockPos().method_10260());
        }));
        list.add(new AbstractListener.CustomVariable("distance_to_player", () -> {
            LookedBlockData data = this.currentBlockData;
            if (data == null) {
                return "0";
            }
            return Double.toString(data.distance());
        }));
    }

    @Override
    @NotNull
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)"fancymenu.listeners.on_start_looking_at_block");
    }

    @Override
    @NotNull
    public List<class_2561> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_start_looking_at_block.desc", new String[0]));
    }

    public record LookedBlockData(@NotNull class_2338 blockPos, @NotNull class_2680 blockState, @NotNull class_5321<class_1937> levelKey, @Nullable String blockKey, double distance) {
        private boolean isSameTarget(@NotNull LookedBlockData other) {
            return Objects.equals(this.blockPos, other.blockPos) && Objects.equals(this.blockState, other.blockState) && Objects.equals(this.levelKey, other.levelKey);
        }

        @NotNull
        public static LookedBlockData from(@NotNull class_638 level, @NotNull class_3965 hitResult, double distance) {
            class_2338 pos = hitResult.method_17777().method_10062();
            class_2680 state = level.method_8320(pos);
            class_5321 levelKey = level.method_27983();
            class_2960 blockKeyLocation = class_7923.field_41175.method_10221((Object)state.method_26204());
            String blockKey = blockKeyLocation != null ? blockKeyLocation.toString() : null;
            return new LookedBlockData(pos, state, (class_5321<class_1937>)levelKey, blockKey, distance);
        }
    }
}

