/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.advanced;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.events.ModReloadEvent;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.json.JsonUtils;
import de.keksuccino.konkrete.web.WebUtils;
import java.io.File;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonPlaceholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final Map<String, List<String>> CACHED_PLACEHOLDERS = Collections.synchronizedMap(new HashMap());
    protected static final Map<String, Long> CURRENTLY_UPDATING_PLACEHOLDERS = new ConcurrentHashMap<String, Long>();
    protected static final List<String> INVALID_WEB_PLACEHOLDER_URLS = Collections.synchronizedList(new ArrayList());
    protected static final long UPDATE_TIMEOUT = 120000L;
    private static Timer cleanupTimer;
    protected static boolean initialized;

    public JsonPlaceholder() {
        super("json");
        if (!initialized) {
            EventHandler.INSTANCE.registerListenersOf(JsonPlaceholder.class);
            JsonPlaceholder.initCleanupTimer();
            initialized = true;
        }
    }

    private static void initCleanupTimer() {
        if (cleanupTimer == null) {
            cleanupTimer = new Timer("FancyMenu-JsonPlaceholder-Cleanup", true);
            cleanupTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    JsonPlaceholder.cleanupStaleUpdates();
                }
            }, 30000L, 30000L);
        }
    }

    protected static void cleanupStaleUpdates() {
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<String, Long>> iterator = CURRENTLY_UPDATING_PLACEHOLDERS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> entry = iterator.next();
            if (currentTime - entry.getValue() <= 120000L) continue;
            String placeholder = entry.getKey();
            iterator.remove();
            LOGGER.warn("[FANCYMENU] Placeholder update timed out for: {}", (Object)placeholder);
        }
    }

    @EventListener
    public static void onReload(ModReloadEvent e) {
        try {
            CACHED_PLACEHOLDERS.clear();
            INVALID_WEB_PLACEHOLDER_URLS.clear();
            CURRENTLY_UPDATING_PLACEHOLDERS.clear();
            LOGGER.info("[FANCYMENU] JsonPlaceholder cache successfully cleared!");
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to reload JsonPlaceholder!", (Throwable)ex);
        }
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        JsonPlaceholder.cleanupStaleUpdates();
        String source = dps.values.get("source");
        String jsonPath = dps.values.get("json_path");
        if (source != null && jsonPath != null) {
            List<String> json;
            if (JsonPlaceholder.isDirectJsonContent(source = StringUtils.convertFormatCodes((String)source, (String)"\u00a7", (String)"&"))) {
                List json2 = JsonUtils.getJsonValueByPath((String)source, (String)jsonPath);
                return JsonPlaceholder.formatJsonToString(json2);
            }
            File f = new File(source);
            if (!f.exists() || !f.getAbsolutePath().replace("\\", "/").startsWith(class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/"))) {
                String linkTemp = class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/") + "/" + source;
                f = new File(linkTemp);
            }
            if (f.isFile()) {
                json = JsonUtils.getJsonValueByPath((File)f, (String)jsonPath);
                return JsonPlaceholder.formatJsonToString(json);
            }
            if (!JsonPlaceholder.isInvalidWebPlaceholderLink(source)) {
                json = JsonPlaceholder.getCachedWebPlaceholder(dps.placeholderString);
                if (json != null) {
                    return JsonPlaceholder.formatJsonToString(json);
                }
                if (!JsonPlaceholder.isWebPlaceholderUpdating(dps.placeholderString)) {
                    JsonPlaceholder.cacheWebPlaceholder(dps.placeholderString, source, jsonPath);
                }
                return "";
            }
        }
        return null;
    }

    private static boolean isDirectJsonContent(String str) {
        if (str == null || str.trim().isEmpty()) {
            return false;
        }
        String trimmed = str.trim();
        if (trimmed.startsWith("{") && trimmed.endsWith("}") || trimmed.startsWith("[") && trimmed.endsWith("]")) {
            try {
                JsonUtils.getJsonValueByPath((String)trimmed, (String)"$");
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    protected static String formatJsonToString(@NotNull List<String> json) {
        if (!json.isEmpty()) {
            if (json.size() == 1) {
                return json.get(0);
            }
            StringBuilder rep = new StringBuilder();
            for (String s2 : json) {
                if (rep.isEmpty()) {
                    rep.append(s2);
                    continue;
                }
                rep.append("%n%").append(s2);
            }
            return rep.toString();
        }
        return "\u00a7c[error while formatting JSON string]";
    }

    protected static boolean isInvalidWebPlaceholderLink(String link) {
        try {
            return INVALID_WEB_PLACEHOLDER_URLS.contains(link);
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Error in JsonPlaceholder!", (Throwable)ex);
            return true;
        }
    }

    protected static List<String> getCachedWebPlaceholder(String placeholder) {
        try {
            return CACHED_PLACEHOLDERS.get(placeholder);
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Error in JsonPlaceholder!", (Throwable)ex);
            return null;
        }
    }

    protected static boolean isWebPlaceholderUpdating(String placeholder) {
        try {
            return CURRENTLY_UPDATING_PLACEHOLDERS.containsKey(placeholder);
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Error in JsonPlaceholder!", (Throwable)ex);
            return true;
        }
    }

    protected static void cacheWebPlaceholder(@NotNull String placeholder, @NotNull String source, @NotNull String jsonPath) {
        try {
            if (!CURRENTLY_UPDATING_PLACEHOLDERS.containsKey(placeholder)) {
                CURRENTLY_UPDATING_PLACEHOLDERS.put(placeholder, System.currentTimeMillis());
                new Thread(() -> {
                    try {
                        if (WebUtils.isValidUrl((String)source)) {
                            String jsonString = JsonPlaceholder.getJsonStringFromURL(source);
                            if (jsonString != null) {
                                CACHED_PLACEHOLDERS.put(placeholder, JsonUtils.getJsonValueByPath((String)jsonString, (String)jsonPath));
                            } else {
                                INVALID_WEB_PLACEHOLDER_URLS.add(source);
                            }
                        } else {
                            INVALID_WEB_PLACEHOLDER_URLS.add(source);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("[FANCYMENU] Error while caching a web JSON in the JsonPlaceholder!", (Throwable)ex);
                    }
                    finally {
                        try {
                            CURRENTLY_UPDATING_PLACEHOLDERS.remove(placeholder);
                        }
                        catch (Exception ex) {
                            LOGGER.error("[FANCYMENU] Error while removing placeholder from updating list!", (Throwable)ex);
                        }
                    }
                }).start();
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Error while caching a web JSON in the JsonPlaceholder!", (Throwable)ex);
            CURRENTLY_UPDATING_PLACEHOLDERS.remove(placeholder);
        }
    }

    @Nullable
    protected static String getJsonStringFromURL(@NotNull String url) {
        try {
            HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 Chrome/91.0.4472.124 Safari/537.36").GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            return response.statusCode() >= 200 && response.statusCode() < 300 ? response.body() : null;
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Error while getting the content of a web JSON in the JsonPlaceholder!", (Throwable)ex);
            return null;
        }
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("source");
        l.add("json_path");
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"fancymenu.placeholders.json", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.json.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662((String)"fancymenu.requirements.categories.advanced", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("source", "path_or_link_or_json_content");
        values.put("json_path", "$.some.json.path");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }

    static {
        initialized = false;
    }
}

