/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinGuiGraphics;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScissorStack;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.FloatBlitRenderState;
import de.keksuccino.fancymenu.util.rendering.FloatColoredRectangleRenderState;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_8030;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class RenderingUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DrawableColor MISSING_TEXTURE_COLOR_MAGENTA = DrawableColor.of(Color.MAGENTA);
    public static final DrawableColor MISSING_TEXTURE_COLOR_BLACK = DrawableColor.BLACK;
    public static final class_2960 FULLY_TRANSPARENT_TEXTURE = class_2960.method_60655((String)"fancymenu", (String)"textures/fully_transparent.png");
    private static final List<DeferredScreenRenderingTask> DEFERRED_SCREEN_RENDERING_TASKS = new ArrayList<DeferredScreenRenderingTask>();
    private static boolean lockDepthTest = false;
    private static boolean blurBlocked = false;
    private static boolean tooltipRenderingBlocked = false;
    private static int overrideBackgroundBlurRadius = -1000;

    public static void renderMissing(@NotNull class_332 graphics, int x, int y, int width, int height) {
        int partW = width / 2;
        int partH = height / 2;
        graphics.method_25294(x, y, x + partW, y + partH, MISSING_TEXTURE_COLOR_MAGENTA.getColorInt());
        graphics.method_25294(x + partW, y, x + width, y + partH, MISSING_TEXTURE_COLOR_BLACK.getColorInt());
        graphics.method_25294(x, y + partH, x + partW, y + height, MISSING_TEXTURE_COLOR_BLACK.getColorInt());
        graphics.method_25294(x + partW, y + partH, x + width, y + height, MISSING_TEXTURE_COLOR_MAGENTA.getColorInt());
    }

    public static void setOverrideBackgroundBlurRadius(int radius) {
        overrideBackgroundBlurRadius = radius;
    }

    public static void resetOverrideBackgroundBlurRadius() {
        overrideBackgroundBlurRadius = -1000;
    }

    public static boolean shouldOverrideBackgroundBlurRadius() {
        return overrideBackgroundBlurRadius != -1000;
    }

    public static int getOverrideBackgroundBlurRadius() {
        return overrideBackgroundBlurRadius;
    }

    public static void setDepthTestLocked(boolean locked) {
        lockDepthTest = locked;
    }

    public static boolean isDepthTestLocked() {
        return lockDepthTest;
    }

    public static void setMenuBlurringBlocked(boolean blocked) {
        blurBlocked = blocked;
    }

    public static boolean isMenuBlurringBlocked() {
        return blurBlocked;
    }

    public static void setTooltipRenderingBlocked(boolean blocked) {
        tooltipRenderingBlocked = blocked;
    }

    public static boolean isTooltipRenderingBlocked() {
        return tooltipRenderingBlocked;
    }

    public static void addDeferredScreenRenderingTask(@NotNull DeferredScreenRenderingTask task) {
        DEFERRED_SCREEN_RENDERING_TASKS.add(task);
    }

    @NotNull
    public static List<DeferredScreenRenderingTask> getDeferredScreenRenderingTasks() {
        return new ArrayList<DeferredScreenRenderingTask>(DEFERRED_SCREEN_RENDERING_TASKS);
    }

    public static void executeAndClearDeferredScreenRenderingTasks(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        List<DeferredScreenRenderingTask> tasks = RenderingUtils.getDeferredScreenRenderingTasks();
        DEFERRED_SCREEN_RENDERING_TASKS.clear();
        tasks.forEach(task -> task.render(graphics, mouseX, mouseY, partial));
    }

    public static void blitMirrored(@NotNull class_332 graphics, class_2960 atlasLocation, int x, int y, int u, int v, int spriteWidth, int spriteHeight, int textureWidth, int textureHeight) {
        RenderingUtils.blitMirroredScaled(graphics, atlasLocation, x, y, u, v, spriteWidth, spriteHeight, spriteWidth, spriteHeight, textureWidth, textureHeight, -1);
    }

    public static void blitMirrored(@NotNull class_332 graphics, class_2960 atlasLocation, int x, int y, int u, int v, int spriteWidth, int spriteHeight, int textureWidth, int textureHeight, int colorTint) {
        RenderingUtils.blitMirroredScaled(graphics, atlasLocation, x, y, u, v, spriteWidth, spriteHeight, spriteWidth, spriteHeight, textureWidth, textureHeight, colorTint);
    }

    public static void blitMirroredScaled(@NotNull class_332 graphics, class_2960 atlasLocation, int x, int y, int u, int v, int spriteWidth, int spriteHeight, int renderWidth, int renderHeight, int textureWidth, int textureHeight, int color) {
        graphics.method_51448().pushMatrix();
        graphics.method_51448().translate((float)x + (float)renderWidth, (float)y);
        graphics.method_51448().scale(-1.0f, 1.0f);
        graphics.method_25293(class_10799.field_56883, atlasLocation, 0, 0, (float)u, (float)v, renderWidth, renderHeight, spriteWidth, spriteHeight, textureWidth, textureHeight, color);
        graphics.method_51448().popMatrix();
    }

    public static void blitRepeat(@NotNull class_332 graphics, @NotNull class_2960 location, int x, int y, int areaRenderWidth, int areaRenderHeight, int texWidth, int texHeight, int color) {
        RenderingUtils.blitRepeat(graphics, class_10799.field_56883, location, x, y, areaRenderWidth, areaRenderHeight, texWidth, texHeight, color);
    }

    public static void blitRepeat(@NotNull class_332 graphics, @NotNull RenderPipeline renderType, @NotNull class_2960 location, int x, int y, int areaRenderWidth, int areaRenderHeight, int texWidth, int texHeight, int color) {
        graphics.method_25291(renderType, location, x, y, 0.0f, 0.0f, areaRenderWidth, areaRenderHeight, texWidth, texHeight, color);
    }

    public static void blitNineSlicedTexture(class_332 graphics, class_2960 texture, int x, int y, int width, int height, int textureWidth, int textureHeight, int borderTop, int borderRight, int borderBottom, int borderLeft, int color) {
        RenderingUtils.blitNineSlicedTexture(graphics, class_10799.field_56883, texture, x, y, width, height, textureWidth, textureHeight, borderTop, borderRight, borderBottom, borderLeft, color);
    }

    public static void blitNineSlicedTexture(class_332 graphics, @NotNull RenderPipeline renderType, class_2960 texture, int x, int y, int width, int height, int textureWidth, int textureHeight, int borderTop, int borderRight, int borderBottom, int borderLeft, int color) {
        int pieceHeight;
        int j;
        int pieceWidth;
        int i;
        float scale;
        if (borderLeft + borderRight >= textureWidth) {
            scale = (float)(textureWidth - 2) / (float)(borderLeft + borderRight);
            borderLeft = (int)((float)borderLeft * scale);
            borderRight = (int)((float)borderRight * scale);
        }
        if (borderTop + borderBottom >= textureHeight) {
            scale = (float)(textureHeight - 2) / (float)(borderTop + borderBottom);
            borderTop = (int)((float)borderTop * scale);
            borderBottom = (int)((float)borderBottom * scale);
        }
        graphics.method_25291(renderType, texture, x, y, 0.0f, 0.0f, borderLeft, borderTop, textureWidth, textureHeight, color);
        graphics.method_25291(renderType, texture, x + width - borderRight, y, (float)(textureWidth - borderRight), 0.0f, borderRight, borderTop, textureWidth, textureHeight, color);
        graphics.method_25291(renderType, texture, x, y + height - borderBottom, 0.0f, (float)(textureHeight - borderBottom), borderLeft, borderBottom, textureWidth, textureHeight, color);
        graphics.method_25291(renderType, texture, x + width - borderRight, y + height - borderBottom, (float)(textureWidth - borderRight), (float)(textureHeight - borderBottom), borderRight, borderBottom, textureWidth, textureHeight, color);
        int centerWidth = textureWidth - borderLeft - borderRight;
        int centerHeight = textureHeight - borderTop - borderBottom;
        for (i = borderLeft; i < width - borderRight; i += centerWidth) {
            pieceWidth = Math.min(centerWidth, width - borderRight - i);
            graphics.method_25291(renderType, texture, x + i, y, (float)borderLeft, 0.0f, pieceWidth, borderTop, textureWidth, textureHeight, color);
        }
        for (i = borderLeft; i < width - borderRight; i += centerWidth) {
            pieceWidth = Math.min(centerWidth, width - borderRight - i);
            graphics.method_25291(renderType, texture, x + i, y + height - borderBottom, (float)borderLeft, (float)(textureHeight - borderBottom), pieceWidth, borderBottom, textureWidth, textureHeight, color);
        }
        for (j = borderTop; j < height - borderBottom; j += centerHeight) {
            pieceHeight = Math.min(centerHeight, height - borderBottom - j);
            graphics.method_25291(renderType, texture, x, y + j, 0.0f, (float)borderTop, borderLeft, pieceHeight, textureWidth, textureHeight, color);
        }
        for (j = borderTop; j < height - borderBottom; j += centerHeight) {
            pieceHeight = Math.min(centerHeight, height - borderBottom - j);
            graphics.method_25291(renderType, texture, x + width - borderRight, y + j, (float)(textureWidth - borderRight), (float)borderTop, borderRight, pieceHeight, textureWidth, textureHeight, color);
        }
        for (i = borderLeft; i < width - borderRight; i += centerWidth) {
            pieceWidth = Math.min(centerWidth, width - borderRight - i);
            for (int j2 = borderTop; j2 < height - borderBottom; j2 += centerHeight) {
                int pieceHeight2 = Math.min(centerHeight, height - borderBottom - j2);
                graphics.method_25291(renderType, texture, x + i, y + j2, (float)borderLeft, (float)borderTop, pieceWidth, pieceHeight2, textureWidth, textureHeight, color);
            }
        }
    }

    public static float getPartialTick() {
        return class_310.method_1551().method_61966().method_60637(false);
    }

    public static boolean isXYInArea(int targetX, int targetY, int x, int y, int width, int height) {
        return RenderingUtils.isXYInArea((double)targetX, (double)targetY, (double)x, (double)y, (double)width, (double)height);
    }

    public static boolean isXYInArea(double targetX, double targetY, double x, double y, double width, double height) {
        return targetX >= x && targetX < x + width && targetY >= y && targetY < y + height;
    }

    public static void resetGuiScale() {
        class_1041 m = class_310.method_1551().method_22683();
        m.method_15997(m.method_4476(((Integer)class_310.method_1551().field_1690.method_42474().method_41753()).intValue(), ((Boolean)class_310.method_1551().field_1690.method_42437().method_41753()).booleanValue()));
    }

    public static int replaceAlphaInColor(int color, int newAlpha) {
        newAlpha = Math.min(newAlpha, 255);
        return color & 0xFFFFFF | newAlpha << 24;
    }

    public static int replaceAlphaInColor(int color, float newAlpha) {
        return RenderingUtils.replaceAlphaInColor(color, (int)(newAlpha * 255.0f));
    }

    public static void fillF(@NotNull class_332 graphics, float minX, float minY, float maxX, float maxY, int color) {
        RenderingUtils.submitColoredRectangle(graphics, class_10799.field_56879, class_11231.method_70899(), minX, minY, maxX, maxY, color, null);
    }

    private static void submitColoredRectangle(@NotNull class_332 graphics, RenderPipeline pipeline, class_11231 textureSetup, float minX, float minY, float maxX, float maxY, int color, @Nullable Integer endColor) {
        class_8030 scissorStackPeek = ((IMixinScissorStack)((IMixinGuiGraphics)graphics).get_scissorStack_FancyMenu()).invoke_peek_FancyMenu();
        ((IMixinGuiGraphics)graphics).get_guiRenderState_FancyMenu().method_70919((class_11244)new FloatColoredRectangleRenderState(pipeline, textureSetup, new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), minX, minY, maxX, maxY, color, endColor != null ? endColor : color, scissorStackPeek));
    }

    public static void blitF(@NotNull class_332 graphics, RenderPipeline renderTypeFunc, class_2960 location, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, int color) {
        RenderingUtils.blitF(graphics, renderTypeFunc, location, $$2, $$3, $$4, $$5, $$6, $$7, $$6, $$7, $$8, $$9, color);
    }

    public static void blitF(@NotNull class_332 graphics, RenderPipeline renderTypeFunc, class_2960 location, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9) {
        RenderingUtils.blitF(graphics, renderTypeFunc, location, $$2, $$3, $$4, $$5, $$6, $$7, $$6, $$7, $$8, $$9);
    }

    public static void blitF(@NotNull class_332 graphics, RenderPipeline renderTypeFunc, class_2960 location, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11) {
        RenderingUtils.blitF(graphics, renderTypeFunc, location, $$2, $$3, $$4, $$5, $$6, $$7, $$8, $$9, $$10, $$11, -1);
    }

    public static void blitF(@NotNull class_332 graphics, RenderPipeline renderTypeFunc, class_2960 location, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11, int color) {
        RenderingUtils.innerBlit(graphics, renderTypeFunc, location, $$2, $$2 + $$6, $$3, $$3 + $$7, ($$4 + 0.0f) / $$10, ($$4 + $$8) / $$10, ($$5 + 0.0f) / $$11, ($$5 + $$9) / $$11, color);
    }

    private static void innerBlit(@NotNull class_332 graphics, RenderPipeline pipeline, class_2960 texture, float minX, float maxX, float minY, float maxY, float minU, float maxU, float minV, float maxV, int color) {
        GpuTextureView textureView = class_310.method_1551().method_1531().method_4619(texture).method_71659();
        RenderingUtils.submitBlit(graphics, pipeline, textureView, minX, minY, maxX, maxY, minU, maxU, minV, maxV, color);
    }

    private static void submitBlit(@NotNull class_332 graphics, RenderPipeline pipeline, GpuTextureView textureView, float minX, float minY, float maxX, float maxY, float minU, float maxU, float minV, float maxV, int color) {
        class_8030 scissorStackPeek = ((IMixinScissorStack)((IMixinGuiGraphics)graphics).get_scissorStack_FancyMenu()).invoke_peek_FancyMenu();
        ((IMixinGuiGraphics)graphics).get_guiRenderState_FancyMenu().method_70919((class_11244)new FloatBlitRenderState(pipeline, class_11231.method_70900((GpuTextureView)textureView), new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), minX, minY, maxX, maxY, minU, maxU, minV, maxV, color, scissorStackPeek));
    }

    public static void blendFuncSeparate(SourceFactor sourceFactor, DestFactor destFactor, SourceFactor sourceFactor2, DestFactor destFactor2) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._blendFuncSeparate((int)sourceFactor.value, (int)destFactor.value, (int)sourceFactor2.value, (int)destFactor2.value);
    }

    public static void defaultBlendFunc() {
        RenderingUtils.blendFuncSeparate(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ZERO);
    }

    public static enum SourceFactor {
        CONSTANT_ALPHA(32771),
        CONSTANT_COLOR(32769),
        DST_ALPHA(772),
        DST_COLOR(774),
        ONE(1),
        ONE_MINUS_CONSTANT_ALPHA(32772),
        ONE_MINUS_CONSTANT_COLOR(32770),
        ONE_MINUS_DST_ALPHA(773),
        ONE_MINUS_DST_COLOR(775),
        ONE_MINUS_SRC_ALPHA(771),
        ONE_MINUS_SRC_COLOR(769),
        SRC_ALPHA(770),
        SRC_ALPHA_SATURATE(776),
        SRC_COLOR(768),
        ZERO(0);

        public final int value;

        private SourceFactor(int value) {
            this.value = value;
        }
    }

    public static enum DestFactor {
        CONSTANT_ALPHA(32771),
        CONSTANT_COLOR(32769),
        DST_ALPHA(772),
        DST_COLOR(774),
        ONE(1),
        ONE_MINUS_CONSTANT_ALPHA(32772),
        ONE_MINUS_CONSTANT_COLOR(32770),
        ONE_MINUS_DST_ALPHA(773),
        ONE_MINUS_DST_COLOR(775),
        ONE_MINUS_SRC_ALPHA(771),
        ONE_MINUS_SRC_COLOR(769),
        SRC_ALPHA(770),
        SRC_COLOR(768),
        ZERO(0);

        public final int value;

        private DestFactor(int value) {
            this.value = value;
        }
    }

    @FunctionalInterface
    public static interface DeferredScreenRenderingTask {
        public void render(@NotNull class_332 var1, int var2, int var3, float var4);
    }
}

