/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen;

import com.google.common.collect.Lists;
import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.cycle.ILocalizedValueCycle;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.text.TextFormattingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.FancyMenuUiComponent;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.InitialWidgetFocusScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.VanillaMouseClickHandlingScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.CycleButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import de.keksuccino.fancymenu.util.window.WindowHandler;
import de.keksuccino.konkrete.input.MouseInput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1041;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_8023;
import net.minecraft.class_8028;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CellScreen
extends class_437
implements InitialWidgetFocusScreen,
VanillaMouseClickHandlingScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    public ScrollArea scrollArea;
    @Nullable
    protected RenderCell selectedCell;
    protected final List<class_339> rightSideWidgets = new ArrayList<class_339>();
    @Nullable
    protected ExtendedButton doneButton;
    @Nullable
    protected ExtendedButton cancelButton;
    protected int lastWidth = 0;
    protected int lastHeight = 0;
    protected final List<RenderCell> allCells = new ArrayList<RenderCell>();
    protected boolean searchBarEnabled = false;
    @Nullable
    protected ExtendedEditBox searchBar;
    @NotNull
    protected class_2561 searchBarPlaceholder = class_2561.method_43471((String)"fancymenu.ui.generic.search");
    protected boolean descriptionAreaEnabled = false;
    @Nullable
    protected ScrollArea descriptionScrollArea;

    protected CellScreen(@NotNull class_2561 title) {
        super(title);
    }

    protected void initCells() {
    }

    protected void initRightSideWidgets() {
    }

    public void rebuild() {
        this.method_25410(class_310.method_1551(), this.field_22789, this.field_22790);
    }

    protected void setSearchBarEnabled(boolean enabled) {
        this.searchBarEnabled = enabled;
    }

    protected void setSearchBarPlaceholder(@NotNull class_2561 placeholder) {
        this.searchBarPlaceholder = placeholder;
    }

    protected void setDescriptionAreaEnabled(boolean enabled) {
        this.descriptionAreaEnabled = enabled;
    }

    @Nullable
    protected List<class_2561> getCurrentDescription() {
        Supplier<List<class_2561>> supplier;
        if (this.selectedCell != null && (supplier = this.selectedCell.getDescriptionSupplier()) != null) {
            return supplier.get();
        }
        return null;
    }

    protected void updateDescriptionArea() {
        if (this.descriptionScrollArea == null) {
            return;
        }
        this.descriptionScrollArea.clearEntries();
        this.descriptionScrollArea.addEntry(new SpacerScrollAreaEntry(this.descriptionScrollArea, 5));
        List<class_2561> description = this.getCurrentDescription();
        if (description != null) {
            for (class_2561 line : description) {
                this.addDescriptionLine(line);
            }
        }
        this.descriptionScrollArea.addEntry(new SpacerScrollAreaEntry(this.descriptionScrollArea, 5));
    }

    protected void addDescriptionLine(@NotNull class_2561 line) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        int maxWidth = (int)(this.descriptionScrollArea.getInnerWidth() - 15.0f);
        if (this.field_22793.method_27525((class_5348)line) > maxWidth) {
            this.field_22793.method_27527().method_27495((class_5348)line, maxWidth, class_2583.field_24360).forEach(formatted -> lines.add((class_2561)TextFormattingUtils.convertFormattedTextToComponent(formatted)));
        } else {
            lines.add(line);
        }
        lines.forEach(component -> {
            TextScrollAreaEntry e = new TextScrollAreaEntry(this.descriptionScrollArea, (class_2561)component, entry -> {});
            e.setSelectable(false);
            e.setBackgroundColorHover(e.getBackgroundColorNormal());
            e.setPlayClickSound(false);
            e.setTextBaseColor(UIBase.getUIColorTheme().description_area_text_color.getColorInt());
            this.descriptionScrollArea.addEntry(e);
        });
    }

    protected void updateCellsVisibility() {
        if (!this.searchBarEnabled || this.searchBar == null || this.scrollArea == null) {
            return;
        }
        String searchValue = this.searchBar.method_1882();
        if (searchValue.isBlank()) {
            searchValue = null;
        }
        float scrollX = this.scrollArea.horizontalScrollBar.getScroll();
        float scrollY = this.scrollArea.verticalScrollBar.getScroll();
        this.scrollArea.clearEntries();
        for (RenderCell cell : this.allCells) {
            if (!this.cellMatchesSearch(cell, searchValue)) continue;
            CellScrollEntry entry = new CellScrollEntry(this.scrollArea, cell);
            this.scrollArea.addEntry(entry);
            cell.updateSize(entry);
            entry.setHeight(cell.getHeight());
        }
        this.scrollArea.horizontalScrollBar.setScroll(scrollX);
        this.scrollArea.verticalScrollBar.setScroll(scrollY);
    }

    protected boolean cellMatchesSearch(@NotNull RenderCell cell, @Nullable String searchValue) {
        List<class_2561> description;
        if (searchValue == null || searchValue.isBlank()) {
            return true;
        }
        if (cell.ignoreSearch) {
            return true;
        }
        String searchLower = searchValue.toLowerCase();
        String cellSearchString = cell.getSearchString();
        if (cellSearchString != null && cellSearchString.toLowerCase().contains(searchLower)) {
            return true;
        }
        Supplier<List<class_2561>> descSupplier = cell.getDescriptionSupplier();
        if (descSupplier != null && (description = descSupplier.get()) != null) {
            for (class_2561 c : description) {
                if (!c.getString().toLowerCase().contains(searchLower)) continue;
                return true;
            }
        }
        return false;
    }

    protected void method_25426() {
        this.rightSideWidgets.clear();
        this.allCells.clear();
        this.selectedCell = null;
        int scrollAreaX = 20;
        int scrollAreaY = 65;
        int scrollAreaWidth = this.field_22789 - 40 - this.getRightSideWidgetWidth() - 20;
        int scrollAreaHeight = this.field_22790 - 85;
        if (this.descriptionAreaEnabled) {
            scrollAreaWidth = this.field_22789 / 2 - 40;
            this.descriptionScrollArea = new ScrollArea(0.0f, 0.0f, 0.0f, 0.0f);
            this.descriptionScrollArea.setWidth(this.field_22789 / 2 - 40, true);
            this.descriptionScrollArea.setHeight(Math.max(40, this.field_22790 / 2 - 50 - 25), true);
            this.descriptionScrollArea.setX((float)(this.field_22789 - 20) - this.descriptionScrollArea.getWidthWithBorder(), true);
            this.descriptionScrollArea.setY(65.0f, true);
            this.descriptionScrollArea.horizontalScrollBar.active = false;
            this.method_37063(this.descriptionScrollArea);
        }
        if (this.searchBarEnabled) {
            scrollAreaY += 25;
            scrollAreaHeight -= 25;
            String oldSearchValue = this.searchBar != null ? this.searchBar.method_1882() : "";
            this.searchBar = new ExtendedEditBox(class_310.method_1551().field_1772, scrollAreaX + 1, 66, scrollAreaWidth - 2, 18, (class_2561)class_2561.method_43473());
            if (this.searchBarPlaceholder != null) {
                this.searchBar.setHintFancyMenu(consumes -> this.searchBarPlaceholder);
            }
            this.searchBar.method_1852(oldSearchValue);
            this.searchBar.method_1863(s -> this.updateCellsVisibility());
            UIBase.applyDefaultWidgetSkinTo(this.searchBar);
            this.searchBar.method_1880(100000);
            this.method_37063((class_364)this.searchBar);
            this.setupInitialFocusWidget(this, (class_364)this.searchBar);
        }
        float oldScrollX = 0.0f;
        float oldScrollY = 0.0f;
        if (this.scrollArea != null) {
            oldScrollX = this.scrollArea.horizontalScrollBar.getScroll();
            oldScrollY = this.scrollArea.verticalScrollBar.getScroll();
        }
        this.scrollArea = new ScrollArea(scrollAreaX, scrollAreaY, scrollAreaWidth, scrollAreaHeight);
        this.initCells();
        this.method_25429(this.scrollArea);
        this.scrollArea.horizontalScrollBar.setScroll(oldScrollX);
        this.scrollArea.verticalScrollBar.setScroll(oldScrollY);
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            if (!(e instanceof CellScrollEntry)) continue;
            CellScrollEntry ce = (CellScrollEntry)e;
            ce.cell.updateSize(ce);
            ce.setHeight(ce.cell.getHeight());
        }
        this.initRightSideWidgets();
        this.addRightSideDefaultSpacer();
        this.cancelButton = this.addRightSideButton(20, (class_2561)class_2561.method_43471((String)"fancymenu.common_components.cancel"), button -> this.onCancel());
        this.doneButton = this.addRightSideButton(20, (class_2561)class_2561.method_43471((String)"fancymenu.common_components.done"), button -> {
            if (this.allowDone()) {
                this.onDone();
            }
        }).setIsActiveSupplier(consumes -> this.allowDone());
        int widgetWidth = this.getRightSideWidgetWidth();
        int widgetX = this.field_22789 - 20 - widgetWidth;
        int widgetY = this.field_22790 - 20;
        class_339 topRightSideWidget = null;
        for (class_339 w : Lists.reverse(this.rightSideWidgets)) {
            if (!(w instanceof RightSideSpacer)) {
                UIBase.applyDefaultWidgetSkinTo(w);
                w.method_46421(widgetX);
                w.method_46419(widgetY - w.method_25364());
                w.method_25358(widgetWidth);
                this.method_37063((class_364)w);
                topRightSideWidget = w;
            }
            widgetY -= w.method_25364() + this.getRightSideDefaultSpaceBetweenWidgets();
        }
        class_1041 window = class_310.method_1551().method_22683();
        boolean resized = window.method_4480() != this.lastWidth || window.method_4507() != this.lastHeight;
        this.lastWidth = window.method_4480();
        this.lastHeight = window.method_4507();
        if (topRightSideWidget.method_46427() < 20 && WindowHandler.getGuiScale() > 1.0) {
            double newScale = WindowHandler.getGuiScale();
            if ((newScale -= 1.0) < 1.0) {
                newScale = 1.0;
            }
            WindowHandler.setGuiScale(newScale);
            this.method_25410(class_310.method_1551(), window.method_4486(), window.method_4502());
        } else if (topRightSideWidget != null && topRightSideWidget.method_46427() >= 20 && resized) {
            RenderingUtils.resetGuiScale();
            this.method_25410(class_310.method_1551(), window.method_4486(), window.method_4502());
        }
        if (this.descriptionAreaEnabled) {
            this.updateDescriptionArea();
        }
    }

    protected void method_56131() {
    }

    protected abstract void onCancel();

    protected abstract void onDone();

    public void method_25419() {
        this.onCancel();
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.updateSelectedCell();
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        class_5250 titleComp = this.field_22785.method_27661().method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        graphics.method_51439(this.field_22793, (class_2561)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        if (this.descriptionAreaEnabled && this.descriptionScrollArea != null) {
            this.descriptionScrollArea.method_25394(graphics, mouseX, mouseY, partial);
        }
        this.scrollArea.method_25394(graphics, mouseX, mouseY, partial);
        super.method_25394(graphics, mouseX, mouseY, partial);
        this.performInitialWidgetFocusActionInRender();
    }

    public void method_25420(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
    }

    public void method_25393() {
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            if (!(e instanceof CellScrollEntry)) continue;
            CellScrollEntry c = (CellScrollEntry)e;
            c.cell.tick();
        }
    }

    public int getRightSideWidgetWidth() {
        return 150;
    }

    public int getRightSideDefaultSpaceBetweenWidgets() {
        return 5;
    }

    public boolean allowDone() {
        return true;
    }

    public boolean allowEnterForDone() {
        return true;
    }

    protected void addRightSideDefaultSpacer() {
        this.addRightSideSpacer(5);
    }

    protected void addRightSideSpacer(int height) {
        this.rightSideWidgets.add(new RightSideSpacer(this, height));
    }

    protected <T> CycleButton<T> addRightSideCycleButton(int height, @NotNull ILocalizedValueCycle<T> cycle, @NotNull CycleButton.CycleButtonClickFeedback<T> clickFeedback) {
        return this.addRightSideWidget((T)new CycleButton<T>(0, 0, 0, height, cycle, clickFeedback));
    }

    protected ExtendedButton addRightSideButton(int height, @NotNull class_2561 label, @NotNull Consumer<ExtendedButton> onClick) {
        return this.addRightSideWidget(new ExtendedButton(0, 0, 0, height, label, var1 -> onClick.accept((ExtendedButton)var1)));
    }

    protected <T extends class_339> T addRightSideWidget(@NotNull T widget) {
        this.rightSideWidgets.add(widget);
        return widget;
    }

    @NotNull
    protected TextInputCell addTextInputCell(@Nullable CharacterFilter characterFilter, boolean allowEditor, boolean allowEditorPlaceholders) {
        return this.addCell(new TextInputCell(characterFilter, allowEditor, allowEditorPlaceholders));
    }

    @NotNull
    protected LabelCell addLabelCell(@NotNull class_2561 text) {
        return this.addCell(new LabelCell(this, text));
    }

    protected void addDescriptionEndSeparatorCell() {
        this.addSpacerCell(5);
        this.addSeparatorCell();
        this.addSpacerCell(5);
    }

    @NotNull
    protected SeparatorCell addSeparatorCell(int height) {
        return this.addCell(new SeparatorCell(height));
    }

    @NotNull
    protected SeparatorCell addSeparatorCell() {
        return this.addCell(new SeparatorCell());
    }

    @NotNull
    protected SpacerCell addCellGroupEndSpacerCell() {
        return this.addSpacerCell(7);
    }

    @NotNull
    protected SpacerCell addStartEndSpacerCell() {
        return this.addSpacerCell(20);
    }

    @NotNull
    protected SpacerCell addSpacerCell(int height) {
        return this.addCell(new SpacerCell(this, height));
    }

    @NotNull
    protected <T> WidgetCell addCycleButtonCell(@NotNull ILocalizedValueCycle<T> cycle, boolean applyDefaultButtonSkin, CycleButton.CycleButtonClickFeedback<T> clickFeedback) {
        return this.addWidgetCell((class_339)new CycleButton<T>(0, 0, 20, 20, cycle, clickFeedback), applyDefaultButtonSkin);
    }

    @NotNull
    protected WidgetCell addWidgetCell(@NotNull class_339 widget, boolean applyDefaultButtonSkin) {
        return this.addCell(new WidgetCell(widget, applyDefaultButtonSkin));
    }

    @NotNull
    protected <T extends RenderCell> T addCell(@NotNull T cell) {
        this.allCells.add(cell);
        if (cell.ignoreSearch || !this.searchBarEnabled || this.searchBar == null || this.cellMatchesSearch(cell, this.searchBar.method_1882())) {
            CellScrollEntry entry = new CellScrollEntry(this.scrollArea, cell);
            this.scrollArea.addEntry(entry);
        }
        return (T)((RenderCell)this.method_25429((class_364)cell));
    }

    protected void updateSelectedCell() {
        RenderCell last = this.selectedCell;
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            if (!(e instanceof CellScrollEntry)) continue;
            CellScrollEntry c = (CellScrollEntry)e;
            if (!c.cell.selectable || !c.cell.selected) continue;
            this.selectedCell = c.cell;
            if (last != this.selectedCell) {
                this.updateDescriptionArea();
            }
            return;
        }
        this.selectedCell = null;
        if (last != this.selectedCell) {
            this.updateDescriptionArea();
        }
    }

    @Nullable
    protected RenderCell getSelectedCell() {
        return this.selectedCell;
    }

    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        if (this.searchBarEnabled && this.searchBar != null && !this.searchBar.method_49606() && this.searchBar.method_25370()) {
            this.method_25395(null);
        }
        for (class_364 listener : this.method_25396()) {
            if (!listener.method_25402(event, isDoubleClick)) continue;
            this.method_25395(listener);
            if (event.method_74245() == 0) {
                this.method_25398(true);
            }
            return true;
        }
        return false;
    }

    public boolean method_25404(class_11908 event) {
        if (event.comp_4795() == 257 && this.allowDone() && this.allowEnterForDone()) {
            this.onDone();
            return true;
        }
        return super.method_25404(event);
    }

    public class_8023.class_8024 method_48264(class_8028 $$0) {
        return null;
    }

    public class_8023.class_8026 method_48266(boolean $$0) {
        return null;
    }

    public abstract class RenderCell
    extends class_362
    implements class_4068,
    class_6379,
    FancyMenuUiComponent {
        protected int x;
        protected int y;
        protected int width;
        protected int height;
        private boolean selectable = false;
        private boolean selected = false;
        protected boolean hovered = false;
        protected Supplier<DrawableColor> hoverColorSupplier = () -> UIBase.getUIColorTheme().list_entry_color_selected_hovered;
        @Nullable
        protected Supplier<List<class_2561>> descriptionSupplier = null;
        @NotNull
        protected Supplier<String> searchStringSupplier = () -> null;
        protected final List<class_364> children = new ArrayList<class_364>();
        protected final Map<String, String> memory = new HashMap<String, String>();
        protected boolean ignoreSearch = false;

        public abstract void renderCell(@NotNull class_332 var1, int var2, int var3, float var4);

        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            if (!this.selectable) {
                this.selected = false;
            }
            this.renderCell(graphics, mouseX, mouseY, partial);
            for (class_364 l : this.children) {
                if (!(l instanceof class_4068)) continue;
                class_4068 r = (class_4068)l;
                r.method_25394(graphics, mouseX, mouseY, partial);
            }
        }

        public void tick() {
        }

        protected void updateSize(@NotNull CellScrollEntry scrollEntry) {
            this.setWidth((int)(CellScreen.this.scrollArea.getInnerWidth() - 40.0f));
            this.setHeight(20);
        }

        protected void updatePosition(@NotNull CellScrollEntry scrollEntry) {
            this.setX((int)(scrollEntry.getX() + 20.0f));
            this.setY((int)scrollEntry.getY());
        }

        @Nullable
        public String getSearchString() {
            return this.searchStringSupplier.get();
        }

        @NotNull
        public Supplier<String> getSearchStringSupplier() {
            return this.searchStringSupplier;
        }

        public RenderCell setSearchStringSupplier(@NotNull Supplier<String> searchStringSupplier) {
            this.searchStringSupplier = searchStringSupplier;
            return this;
        }

        @Nullable
        public Supplier<List<class_2561>> getDescriptionSupplier() {
            return this.descriptionSupplier;
        }

        public RenderCell setDescriptionSupplier(@Nullable Supplier<List<class_2561>> descriptionSupplier) {
            this.descriptionSupplier = descriptionSupplier;
            return this;
        }

        public int getTopBottomSpace() {
            return 3;
        }

        public int getX() {
            return this.x;
        }

        public RenderCell setX(int x) {
            this.x = x;
            return this;
        }

        public int getY() {
            return this.y + this.getTopBottomSpace();
        }

        public RenderCell setY(int y) {
            this.y = y;
            return this;
        }

        public int getWidth() {
            return this.width;
        }

        public RenderCell setWidth(int width) {
            this.width = width;
            return this;
        }

        public int getHeight() {
            return this.height + this.getTopBottomSpace() * 2;
        }

        public RenderCell setHeight(int height) {
            this.height = height;
            return this;
        }

        public boolean isHovered() {
            return this.hovered;
        }

        public RenderCell setSelected(boolean selected) {
            this.selected = selected;
            if (!this.selectable) {
                this.selected = false;
            }
            if (CellScreen.this.descriptionAreaEnabled) {
                CellScreen.this.updateDescriptionArea();
            }
            return this;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public boolean isSelectable() {
            return this.selectable;
        }

        public RenderCell setSelectable(boolean selectable) {
            this.selectable = selectable;
            if (!this.selectable) {
                this.setSelected(false);
            }
            return this;
        }

        public RenderCell setHoverColorSupplier(@NotNull Supplier<DrawableColor> hoverColorSupplier) {
            this.hoverColorSupplier = hoverColorSupplier;
            return this;
        }

        public RenderCell putMemoryValue(@NotNull String key, @NotNull String value) {
            this.memory.put(key, value);
            return this;
        }

        public RenderCell setIgnoreSearch() {
            this.ignoreSearch = true;
            return this;
        }

        @Nullable
        public String getMemoryValue(@NotNull String key) {
            return this.memory.get(key);
        }

        @NotNull
        public List<class_364> method_25396() {
            return this.children;
        }

        @NotNull
        public class_6379.class_6380 method_37018() {
            return class_6379.class_6380.field_33784;
        }

        public void method_37020(@NotNull class_6382 var1) {
        }

        public boolean method_25402(class_11909 event, boolean isDoubleClick) {
            if (CellScreen.this.scrollArea.isMouseInteractingWithGrabbers()) {
                return false;
            }
            if (!CellScreen.this.scrollArea.isInnerAreaHovered()) {
                return false;
            }
            if (this.hovered && this.selectable) {
                this.setSelected(true);
            } else {
                this.setSelected(false);
            }
            return super.method_25402(event, isDoubleClick);
        }

        public boolean method_25403(class_11909 event, double $$3, double $$4) {
            if (CellScreen.this.scrollArea.isMouseInteractingWithGrabbers()) {
                return false;
            }
            return super.method_25403(event, $$3, $$4);
        }

        public boolean method_25406(class_11909 event) {
            if (CellScreen.this.scrollArea.isMouseInteractingWithGrabbers()) {
                return false;
            }
            return super.method_25406(event);
        }
    }

    public static class SpacerScrollAreaEntry
    extends TextScrollAreaEntry {
        private int spacerHeight;

        public SpacerScrollAreaEntry(ScrollArea parent, int height) {
            super(parent, (class_2561)class_2561.method_43473(), button -> {});
            this.spacerHeight = height;
            this.height = height;
        }

        @Override
        public float getHeight() {
            return this.spacerHeight;
        }

        @Override
        public void setHeight(float height) {
            this.spacerHeight = (int)height;
        }
    }

    protected class CellScrollEntry
    extends ScrollAreaEntry {
        public final RenderCell cell;

        public CellScrollEntry(@NotNull ScrollArea parent, RenderCell cell) {
            super(parent, 10.0f, 10.0f);
            this.clickable = false;
            this.selectable = false;
            this.selectOnClick = false;
            this.playClickSound = false;
            this.setBackgroundColorHover(this.getBackgroundColorNormal());
            this.cell = cell;
        }

        @Override
        public void renderEntry(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            this.cell.updateSize(this);
            this.setWidth(this.cell.getWidth() + 40);
            if (this.getWidth() < this.parent.getInnerWidth()) {
                this.setWidth(this.parent.getInnerWidth());
            }
            this.setHeight(this.cell.getHeight());
            this.cell.updatePosition(this);
            this.cell.hovered = UIBase.isXYInArea((double)mouseX, (double)mouseY, this.getX(), this.getY(), this.parent.getInnerWidth(), this.getHeight());
            if (this.cell.isSelectable() && this.cell.isHovered() || this.cell == CellScreen.this.selectedCell) {
                graphics.method_25294((int)this.getX(), (int)this.getY(), (int)(this.getX() + this.parent.getInnerWidth()), (int)(this.getY() + this.getHeight()), this.cell.hoverColorSupplier.get().getColorInt());
            }
            this.cell.method_25394(graphics, mouseX, mouseY, partial);
        }

        @Override
        public void onClick(ScrollAreaEntry entry, double mouseX, double mouseY, int button) {
        }
    }

    protected class RightSideSpacer
    extends class_339 {
        protected RightSideSpacer(CellScreen this$0, int height) {
            super(0, 0, 0, height, (class_2561)class_2561.method_43473());
        }

        public void method_25365(boolean var1) {
        }

        public void method_48579(class_332 graphics, int var2, int var3, float var4) {
        }

        public boolean method_25370() {
            return false;
        }

        protected void method_47399(class_6382 var1) {
        }
    }

    public class TextInputCell
    extends RenderCell {
        public ExtendedEditBox editBox;
        public ExtendedButton openEditorButton;
        public final boolean allowEditor;
        protected boolean widgetSizesSet = false;
        protected BiConsumer<String, TextInputCell> editorCallback = (s, cell) -> cell.editBox.method_1852(s.replace("\n", "\\n"));
        protected ConsumingSupplier<TextInputCell, String> editorSetTextSupplier = consumes -> {
            if (this.editorMultiLineMode) {
                return consumes.editBox.method_1882().replace("\\n", "\n");
            }
            return consumes.editBox.method_1882().replace("\n", "\\n");
        };
        protected boolean editorMultiLineMode = false;

        public TextInputCell(CharacterFilter characterFilter, boolean allowEditor, boolean allowEditorPlaceholders) {
            this.allowEditor = allowEditor;
            this.editBox = new ExtendedEditBox(class_310.method_1551().field_1772, 0, 0, 20, 18, (class_2561)class_2561.method_43473());
            this.editBox.method_1880(1000000);
            this.editBox.setCharacterFilter(characterFilter);
            UIBase.applyDefaultWidgetSkinTo(this.editBox);
            this.method_25396().add((class_364)this.editBox);
            if (this.allowEditor) {
                this.openEditorButton = new ExtendedButton(0, 0, 20, 20, (class_2561)class_2561.method_43471((String)"fancymenu.ui.screens.string_builder_screen.edit_in_editor"), button -> {
                    if (allowEditor) {
                        TextEditorScreen s = new TextEditorScreen(characterFilter != null ? characterFilter : null, callback -> {
                            if (callback != null) {
                                this.editorCallback.accept((String)callback, this);
                            }
                            class_310.method_1551().method_1507((class_437)CellScreen.this);
                        });
                        s.setMultilineMode(this.editorMultiLineMode);
                        s.setPlaceholdersAllowed(allowEditorPlaceholders);
                        s.setText(this.editorSetTextSupplier.get(this));
                        class_310.method_1551().method_1507((class_437)s);
                    }
                });
                UIBase.applyDefaultWidgetSkinTo(this.openEditorButton);
                this.method_25396().add((class_364)this.openEditorButton);
            }
            this.setSearchStringSupplier(() -> this.editBox.method_1882());
        }

        @Override
        public void renderCell(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            if (!this.widgetSizesSet) {
                this.setWidgetSizes();
                this.widgetSizesSet = true;
            }
            this.editBox.method_46421(this.getX() + 1);
            this.editBox.method_46419(this.getY() + 1);
            if (this.allowEditor) {
                this.openEditorButton.method_46421(this.getX() + this.getWidth() - this.openEditorButton.method_25368());
                this.openEditorButton.method_46419(this.getY());
            }
            if (MouseInput.isLeftMouseDown() && !this.editBox.method_49606()) {
                this.editBox.method_25365(false);
            }
        }

        protected void setWidgetSizes() {
            int editorButtonWidth = (this.allowEditor ? class_310.method_1551().field_1772.method_27525((class_5348)this.openEditorButton.getLabelSupplier().get(this.openEditorButton)) : 0) + 6;
            this.editBox.method_25358(this.allowEditor ? this.getWidth() - editorButtonWidth - 5 : this.getWidth());
            if (this.allowEditor) {
                this.openEditorButton.method_25358(editorButtonWidth);
            }
        }

        public TextInputCell setEditorPresetTextSupplier(@NotNull ConsumingSupplier<TextInputCell, String> supplier) {
            this.editorSetTextSupplier = Objects.requireNonNull(supplier);
            return this;
        }

        public TextInputCell setEditorCallback(@NotNull BiConsumer<String, TextInputCell> callback) {
            this.editorCallback = Objects.requireNonNull(callback);
            return this;
        }

        public TextInputCell setEditListener(@Nullable Consumer<String> listener) {
            this.editBox.method_1863(listener);
            return this;
        }

        @NotNull
        public String getText() {
            return this.editBox.method_1882();
        }

        public TextInputCell setText(@Nullable String text) {
            if (text == null) {
                text = "";
            }
            this.editBox.method_1852(text);
            this.editBox.method_1875(0);
            this.editBox.method_1884(0);
            this.editBox.setDisplayPosition(0);
            return this;
        }

        public boolean isEditorMultiLineMode() {
            return this.editorMultiLineMode;
        }

        public TextInputCell setEditorMultiLineMode(boolean editorMultiLineMode) {
            this.editorMultiLineMode = editorMultiLineMode;
            return this;
        }
    }

    public class LabelCell
    extends RenderCell {
        @NotNull
        protected class_2561 text;

        public LabelCell(@NotNull CellScreen this$0, class_2561 label) {
            this.text = label;
            this.setSearchStringSupplier(() -> this.text.getString());
        }

        @Override
        public void renderCell(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            UIBase.drawElementLabel(graphics, class_310.method_1551().field_1772, this.text, this.getX(), this.getY());
        }

        @Override
        protected void updateSize(@NotNull CellScrollEntry scrollEntry) {
            this.setWidth(class_310.method_1551().field_1772.method_27525((class_5348)this.text));
            Objects.requireNonNull(class_310.method_1551().field_1772);
            this.setHeight(9);
        }

        @NotNull
        public class_2561 getText() {
            return this.text;
        }

        public LabelCell setText(@NotNull class_2561 text) {
            this.text = text;
            return this;
        }
    }

    public class SpacerCell
    extends RenderCell {
        public SpacerCell(CellScreen this$0, int height) {
            this.setHeight(height);
            this.setWidth(10);
        }

        @Override
        public int getTopBottomSpace() {
            return 0;
        }

        @Override
        public boolean isSelectable() {
            return false;
        }

        @Override
        public RenderCell setSelectable(boolean selectable) {
            throw new RuntimeException("You can't make SpacerCells selectable.");
        }

        @Override
        public void renderCell(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        }

        @Override
        protected void updateSize(@NotNull CellScrollEntry scrollEntry) {
        }
    }

    public class SeparatorCell
    extends RenderCell {
        protected Supplier<DrawableColor> separatorColorSupplier = () -> UIBase.getUIColorTheme().element_border_color_normal;
        protected int separatorThickness = 1;

        public SeparatorCell() {
            this.setHeight(10);
        }

        public SeparatorCell(int height) {
            this.setHeight(height);
        }

        @Override
        public int getTopBottomSpace() {
            return 0;
        }

        @Override
        public void renderCell(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            int centerY = this.getY() + this.getHeight() / 2;
            int halfThickness = Math.max(1, this.separatorThickness / 2);
            graphics.method_25294(this.getX(), centerY - (halfThickness > 1 ? halfThickness : 0), this.getX() + this.getWidth(), centerY + halfThickness, this.separatorColorSupplier.get().getColorInt());
        }

        @Override
        protected void updateSize(@NotNull CellScrollEntry scrollEntry) {
            this.setWidth((int)(CellScreen.this.scrollArea.getInnerWidth() - 40.0f));
        }

        @NotNull
        public Supplier<DrawableColor> getSeparatorColorSupplier() {
            return this.separatorColorSupplier;
        }

        public SeparatorCell setSeparatorColorSupplier(@NotNull Supplier<DrawableColor> separatorColorSupplier) {
            this.separatorColorSupplier = separatorColorSupplier;
            return this;
        }

        public int getSeparatorThickness() {
            return this.separatorThickness;
        }

        public SeparatorCell setSeparatorThickness(int separatorThickness) {
            this.separatorThickness = separatorThickness;
            return this;
        }
    }

    public class WidgetCell
    extends RenderCell {
        public final class_339 widget;

        public WidgetCell(class_339 widget, boolean applyDefaultSkin) {
            this.widget = widget;
            if (applyDefaultSkin) {
                UIBase.applyDefaultWidgetSkinTo(this.widget);
            }
            this.method_25396().add((class_364)this.widget);
            this.setSearchStringSupplier(() -> this.widget.method_25369().getString());
        }

        @Override
        public void renderCell(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            this.widget.method_46421(this.getX());
            this.widget.method_46419(this.getY());
            this.widget.method_25358(this.getWidth());
        }

        @Override
        protected void updateSize(@NotNull CellScrollEntry scrollEntry) {
            this.setWidth((int)(CellScreen.this.scrollArea.getInnerWidth() - 40.0f));
            this.setHeight(this.widget.method_25364());
        }
    }
}

