/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget;

import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.UniqueWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.FancyMenuWidget;
import java.util.Objects;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextWidget
extends class_339
implements UniqueWidget,
NavigatableWidget,
FancyMenuWidget {
    @Nullable
    protected String widgetIdentifier;
    @NotNull
    protected TextAlignment alignment = TextAlignment.LEFT;
    @NotNull
    protected DrawableColor baseColor = DrawableColor.WHITE;
    protected boolean shadow = true;
    @NotNull
    protected class_327 font;
    protected float scale = 1.0f;

    @NotNull
    public static TextWidget empty(int x, int y, int width) {
        return new TextWidget(x, y, width, 9, class_310.method_1551().field_1772, (class_2561)class_2561.method_43473());
    }

    @NotNull
    public static TextWidget of(@NotNull class_2561 text, int x, int y, int width) {
        return new TextWidget(x, y, width, 9, class_310.method_1551().field_1772, text);
    }

    @NotNull
    public static TextWidget of(@NotNull String text, int x, int y, int width) {
        return TextWidget.of((class_2561)class_2561.method_43470((String)text), x, y, width);
    }

    public TextWidget(int x, int y, int width, int height, @NotNull class_327 font, @NotNull class_2561 text) {
        super(x, y, width, height, text);
        this.font = font;
        this.updateIntrinsicSize();
    }

    public void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        double drawX = this.getRenderX();
        double drawY = this.getRenderY();
        float currentScale = this.scale;
        graphics.method_51448().pushMatrix();
        if (currentScale != 1.0f) {
            graphics.method_51448().scale(currentScale, currentScale);
            drawX /= (double)currentScale;
            drawY /= (double)currentScale;
        }
        graphics.method_51439(this.font, this.method_25369(), class_3532.method_15357((double)drawX), class_3532.method_15357((double)drawY), this.baseColor.getColorInt(), this.shadow);
        graphics.method_51448().popMatrix();
    }

    public int getTextWidth() {
        return class_3532.method_15384((double)this.getScaledTextWidth());
    }

    public double getScaledTextWidth() {
        return (float)this.font.method_30880(this.method_25369().method_30937()) * this.scale;
    }

    public double getScaledTextHeight() {
        Objects.requireNonNull(this.font);
        return 9.0f * this.scale;
    }

    public double getRenderX() {
        double textWidth = this.getScaledTextWidth();
        double x = this.method_46426();
        if (this.alignment == TextAlignment.CENTER) {
            x = (double)this.method_46426() + (double)this.method_25368() / 2.0 - textWidth / 2.0;
        } else if (this.alignment == TextAlignment.RIGHT) {
            x = (double)(this.method_46426() + this.method_25368()) - textWidth;
        }
        return x;
    }

    public double getRenderY() {
        return this.method_46427();
    }

    public float getScale() {
        return this.scale;
    }

    public TextWidget setScale(float scale) {
        this.scale = Math.max(1.0E-4f, scale);
        this.updateIntrinsicSize();
        return this;
    }

    @NotNull
    public TextAlignment getTextAlignment() {
        return this.alignment;
    }

    public TextWidget setTextAlignment(@NotNull TextAlignment alignment) {
        this.alignment = alignment;
        return this;
    }

    @NotNull
    public DrawableColor getBaseColor() {
        return this.baseColor;
    }

    public TextWidget setBaseColor(@NotNull DrawableColor baseColor) {
        this.baseColor = baseColor;
        return this;
    }

    public boolean isShadowEnabled() {
        return this.shadow;
    }

    public TextWidget setShadowEnabled(boolean enabled) {
        this.shadow = enabled;
        return this;
    }

    @NotNull
    public class_327 getFont() {
        return this.font;
    }

    public TextWidget setFont(@NotNull class_327 font) {
        this.font = font;
        this.updateIntrinsicSize();
        return this;
    }

    public TextWidget centerWidget(@NotNull class_437 parent) {
        this.method_46421(parent.field_22789 / 2 - this.method_25368() / 2);
        return this;
    }

    public boolean isTextHovered(double mouseX, double mouseY) {
        double x = this.getRenderX();
        double y = this.getRenderY();
        double width = this.getScaledTextWidth();
        double height = this.getScaledTextHeight();
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    @Nullable
    public class_2583 getStyleAtMouseX(double mouseX) {
        double left = this.getRenderX();
        double right = left + this.getScaledTextWidth();
        if (mouseX < left || mouseX > right) {
            return null;
        }
        float safeScale = Math.max(1.0E-4f, this.scale);
        double relative = (mouseX - left) / (double)safeScale;
        return this.font.method_27527().method_27489((class_5348)this.method_25369(), class_3532.method_15357((double)relative));
    }

    @Override
    public TextWidget setWidgetIdentifierFancyMenu(@Nullable String identifier) {
        this.widgetIdentifier = identifier;
        return this;
    }

    @Override
    @Nullable
    public String getWidgetIdentifierFancyMenu() {
        return this.widgetIdentifier;
    }

    protected void method_47399(@NotNull class_6382 var1) {
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setFocusable(boolean focusable) {
        throw new RuntimeException("TextWidgets are not focusable!");
    }

    @Override
    public boolean isNavigatable() {
        return false;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
        throw new RuntimeException("TextWidgets are not navigatable!");
    }

    public void method_25354(@NotNull class_1144 $$0) {
    }

    protected void updateIntrinsicSize() {
        Objects.requireNonNull(this.font);
        this.field_22759 = Math.max(1, class_3532.method_15386((float)(9.0f * this.scale)));
    }

    public static enum TextAlignment {
        LEFT,
        RIGHT,
        CENTER;

    }
}

