/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mixin.mixins.common.client;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.listener.listeners.Listeners;
import de.keksuccino.fancymenu.customization.listener.listeners.OnStartLookingAtBlockListener;
import de.keksuccino.fancymenu.customization.listener.listeners.OnStartLookingAtEntityListener;
import de.keksuccino.fancymenu.customization.listener.listeners.OnStopLookingAtBlockListener;
import de.keksuccino.fancymenu.customization.listener.listeners.OnStopLookingAtEntityListener;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public class MixinGameRenderer {
    @Unique
    private static final double ENTITY_LOOK_DISTANCE_FANCYMENU = 20.0;
    @Unique
    private static final double BLOCK_LOOK_DISTANCE_FANCYMENU = 20.0;
    @Shadow
    @Final
    Minecraft minecraft;

    @Inject(method={"processBlurEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void head_processBlurEffect_FancyMenu(float radius, CallbackInfo info) {
        if (RenderingUtils.isMenuBlurringBlocked()) {
            info.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void before_render_FancyMenu(DeltaTracker $$0, boolean $$1, CallbackInfo info) {
        ScreenCustomization.onPreGameRenderTick();
    }

    @Inject(method={"pick(F)V"}, at={@At(value="TAIL")})
    private void tail_onPick_FancyMenu(float partialTicks, CallbackInfo info) {
        BlockHitResult blockHitResult;
        if (this.minecraft == null) {
            return;
        }
        HitResult hitResult = this.minecraft.hitResult;
        OnStartLookingAtBlockListener startBlockListener = Listeners.ON_START_LOOKING_AT_BLOCK;
        OnStopLookingAtBlockListener stopBlockListener = Listeners.ON_STOP_LOOKING_AT_BLOCK;
        OnStartLookingAtEntityListener startLookingListener = Listeners.ON_START_LOOKING_AT_ENTITY;
        OnStopLookingAtEntityListener stopLookingListener = Listeners.ON_STOP_LOOKING_AT_ENTITY;
        if (hitResult == null) {
            MixinGameRenderer.stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            MixinGameRenderer.stopLooking_FancyMenu(startLookingListener, stopLookingListener);
            return;
        }
        Entity cameraEntity = this.minecraft.getCameraEntity();
        if (cameraEntity == null) {
            MixinGameRenderer.stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            MixinGameRenderer.stopLooking_FancyMenu(startLookingListener, stopLookingListener);
            return;
        }
        Vec3 eyePosition = cameraEntity.getEyePosition(partialTicks);
        EntityHitResult extendedEntityHit = MixinGameRenderer.findExtendedEntityHit_FancyMenu(cameraEntity, partialTicks);
        if (extendedEntityHit == null && hitResult instanceof EntityHitResult) {
            EntityHitResult vanillaEntityHit;
            extendedEntityHit = vanillaEntityHit = (EntityHitResult)hitResult;
        }
        if (extendedEntityHit != null) {
            Entity targetEntity = extendedEntityHit.getEntity();
            double distance = extendedEntityHit.getLocation().distanceTo(eyePosition);
            startLookingListener.onLookAtEntity(targetEntity, distance);
            MixinGameRenderer.stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            return;
        }
        MixinGameRenderer.stopLooking_FancyMenu(startLookingListener, stopLookingListener);
        ClientLevel distance = this.minecraft.level;
        if (!(distance instanceof ClientLevel)) {
            MixinGameRenderer.stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            return;
        }
        ClientLevel clientLevel = distance;
        HitResult blockPickResult = cameraEntity.pick(20.0, partialTicks, false);
        if (!(blockPickResult instanceof BlockHitResult) || (blockHitResult = (BlockHitResult)blockPickResult).getType() != HitResult.Type.BLOCK) {
            MixinGameRenderer.stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            return;
        }
        BlockPos blockPos = blockHitResult.getBlockPos();
        BlockState blockState = clientLevel.getBlockState(blockPos);
        if (blockState.isAir()) {
            MixinGameRenderer.stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            return;
        }
        double distance2 = blockHitResult.getLocation().distanceTo(eyePosition);
        if (distance2 > 20.0) {
            MixinGameRenderer.stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            return;
        }
        OnStartLookingAtBlockListener.LookedBlockData previousBlock = startBlockListener.getCurrentBlockData();
        if (previousBlock != null) {
            boolean sameBlock;
            boolean bl = sameBlock = previousBlock.blockPos().equals((Object)blockPos) && previousBlock.blockState().equals(blockState) && previousBlock.levelKey().equals((Object)clientLevel.dimension());
            if (!sameBlock) {
                stopBlockListener.onStopLooking(previousBlock);
            }
        }
        startBlockListener.onLookAtBlock(clientLevel, blockHitResult, distance2);
    }

    @Unique
    private static void stopLooking_FancyMenu(OnStartLookingAtEntityListener startListener, OnStopLookingAtEntityListener stopListener) {
        OnStartLookingAtEntityListener.LookedEntityData previousEntity = startListener.getCurrentEntityData();
        if (previousEntity != null) {
            stopListener.onStopLooking(previousEntity);
            startListener.clearCurrentEntity();
        }
    }

    @Unique
    private static void stopLookingBlock_FancyMenu(OnStartLookingAtBlockListener startListener, OnStopLookingAtBlockListener stopListener) {
        OnStartLookingAtBlockListener.LookedBlockData previousBlock = startListener.getCurrentBlockData();
        if (previousBlock != null) {
            stopListener.onStopLooking(previousBlock);
        }
        startListener.clearCurrentBlock();
    }

    @Unique
    @Nullable
    private static EntityHitResult findExtendedEntityHit_FancyMenu(Entity cameraEntity, float partialTicks) {
        double blockDistanceSqr;
        double maxDistanceSqr;
        AABB searchBox;
        Vec3 viewVector;
        Vec3 reachVector;
        Vec3 eyePosition = cameraEntity.getEyePosition(partialTicks);
        EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Entity)cameraEntity, (Vec3)eyePosition, (Vec3)(reachVector = eyePosition.add((viewVector = cameraEntity.getViewVector(partialTicks)).scale(20.0))), (AABB)(searchBox = cameraEntity.getBoundingBox().expandTowards(viewVector.scale(20.0)).inflate(1.0)), entity -> !entity.isSpectator() && entity.isPickable(), (double)(maxDistanceSqr = 400.0));
        if (entityHitResult == null) {
            return null;
        }
        Vec3 hitLocation = entityHitResult.getLocation();
        double entityDistanceSqr = hitLocation.distanceToSqr(eyePosition);
        if (entityDistanceSqr > maxDistanceSqr) {
            return null;
        }
        HitResult blockHitResult = cameraEntity.pick(20.0, partialTicks, false);
        if (blockHitResult != null && blockHitResult.getType() != HitResult.Type.MISS && (blockDistanceSqr = blockHitResult.getLocation().distanceToSqr(eyePosition)) <= entityDistanceSqr) {
            return null;
        }
        return entityHitResult;
    }
}

