/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.buddy;

import de.keksuccino.fancymenu.customization.layout.editor.buddy.Buddy;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.items.Poop;
import de.keksuccino.fancymenu.util.rendering.ui.FancyMenuUiComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_332;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_8030;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BuddyWidget
extends class_362
implements class_4068,
class_6379,
FancyMenuUiComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Buddy buddy;
    private final List<class_364> unusedDummyChildren = new ArrayList<class_364>();
    private int screenWidth;
    private int screenHeight;
    private boolean fullyInitialized = false;
    private int saveTimer = 0;
    private static final int SAVE_INTERVAL = 2400;

    public BuddyWidget(int screenWidth, int screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        LOGGER.debug("Creating new TamagotchiEasterEgg with screen size: {}x{}", (Object)screenWidth, (Object)screenHeight);
        this.buddy = new Buddy(screenWidth, screenHeight);
        if (screenWidth > 0 && screenHeight > 0) {
            this.loadBuddyState();
            this.fullyInitialized = true;
        } else {
            LOGGER.debug("Delaying buddy state loading until screen size is properly set");
        }
    }

    private void loadBuddyState() {
        if (!this.buddy.loadState()) {
            LOGGER.debug("No saved state found, starting with default buddy state");
        } else {
            LOGGER.debug("Successfully loaded saved buddy state");
            List<Poop> poops = this.buddy.getPoops();
            if (poops.isEmpty()) {
                LOGGER.debug("No poops loaded");
            } else {
                LOGGER.debug("Loaded {} poops, current positions:", (Object)poops.size());
                for (int i = 0; i < poops.size(); ++i) {
                    Poop poop = poops.get(i);
                    LOGGER.debug("  Poop {}: ({}, {})", (Object)(i + 1), (Object)poop.getX(), (Object)poop.getY());
                }
            }
        }
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.buddy.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    public void tick() {
        this.buddy.tick();
        ++this.saveTimer;
        if (this.saveTimer >= 2400) {
            this.saveTimer = 0;
            this.buddy.saveState();
            LOGGER.debug("Auto-saved buddy state");
            List<Poop> poops = this.buddy.getPoops();
            if (!poops.isEmpty()) {
                LOGGER.debug("Current poop positions after save:");
                for (int i = 0; i < poops.size(); ++i) {
                    Poop poop = poops.get(i);
                    LOGGER.debug("  Poop {}: ({}, {})", (Object)(i + 1), (Object)poop.getX(), (Object)poop.getY());
                }
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.buddy.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return this.buddy.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.buddy.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        return this.buddy.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        return this.unusedDummyChildren;
    }

    public class_8030 method_48202() {
        return new class_8030(0, 0, this.screenWidth, this.screenHeight);
    }

    public void setScreenSize(int width, int height) {
        LOGGER.debug("TamagotchiEasterEgg screen size changed: {}x{} -> {}x{}", (Object)this.screenWidth, (Object)this.screenHeight, (Object)width, (Object)height);
        this.screenWidth = width;
        this.screenHeight = height;
        this.buddy.setScreenSize(width, height);
        if (!this.fullyInitialized && width > 0 && height > 0) {
            LOGGER.debug("Screen size now valid, loading buddy state");
            this.loadBuddyState();
            this.fullyInitialized = true;
        }
    }

    @NotNull
    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(@NotNull class_6382 var1) {
    }

    public void cleanup() {
        LOGGER.debug("TamagotchiEasterEgg cleanup - saving buddy state");
        this.buddy.saveState();
        if (this.buddy.getLevelingManager() != null) {
            LOGGER.debug("Saving buddy leveling data");
            this.buddy.getLevelingManager().saveState();
        }
    }
}

