/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnEntityInSightListener
extends AbstractListener {
    private final Set<UUID> trackedEntities = new HashSet<UUID>();
    private final Set<UUID> seenThisFrame = new HashSet<UUID>();
    @Nullable
    private String cachedEntityKey;
    @Nullable
    private String cachedDistanceToPlayer;
    @Nullable
    private String cachedEntityPosX;
    @Nullable
    private String cachedEntityPosY;
    @Nullable
    private String cachedEntityPosZ;
    @Nullable
    private String cachedEntityUuidString;

    public OnEntityInSightListener() {
        super("entity_in_sight");
    }

    public void onRenderFrameStart() {
        this.seenThisFrame.clear();
    }

    public void onEntityVisible(@NotNull class_1297 entity, double distanceToPlayer) {
        UUID entityUuid = entity.method_5667();
        this.seenThisFrame.add(entityUuid);
        if (!this.trackedEntities.add(entityUuid)) {
            return;
        }
        class_2960 entityKey = class_7923.field_41177.method_10221((Object)entity.method_5864());
        this.cachedEntityKey = entityKey != null ? entityKey.toString() : null;
        this.cachedDistanceToPlayer = Double.toString(distanceToPlayer);
        this.cachedEntityPosX = Double.toString(entity.method_23317());
        this.cachedEntityPosY = Double.toString(entity.method_23318());
        this.cachedEntityPosZ = Double.toString(entity.method_23321());
        this.cachedEntityUuidString = entityUuid.toString();
        this.notifyAllInstances();
    }

    public void onRenderFrameEnd() {
        if (this.trackedEntities.isEmpty()) {
            return;
        }
        this.trackedEntities.retainAll(this.seenThisFrame);
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("entity_key", () -> this.cachedEntityKey != null ? this.cachedEntityKey : "ERROR"));
        list.add(new AbstractListener.CustomVariable("distance_to_player", () -> this.cachedDistanceToPlayer != null ? this.cachedDistanceToPlayer : "0"));
        list.add(new AbstractListener.CustomVariable("entity_pos_x", () -> this.cachedEntityPosX != null ? this.cachedEntityPosX : "0"));
        list.add(new AbstractListener.CustomVariable("entity_pos_y", () -> this.cachedEntityPosY != null ? this.cachedEntityPosY : "0"));
        list.add(new AbstractListener.CustomVariable("entity_pos_z", () -> this.cachedEntityPosZ != null ? this.cachedEntityPosZ : "0"));
        list.add(new AbstractListener.CustomVariable("entity_uuid", () -> this.cachedEntityUuidString != null ? this.cachedEntityUuidString : "ERROR"));
    }

    @Override
    @NotNull
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)"fancymenu.listeners.on_entity_in_sight");
    }

    @Override
    @NotNull
    public List<class_2561> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_entity_in_sight.desc", new String[0]));
    }
}

