/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnLookingAtBlockListener
extends AbstractListener {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private class_2338 lastBlockPos;
    @Nullable
    private class_2680 lastBlockState;
    @Nullable
    private class_5321<class_1937> lastLevelKey;
    @Nullable
    private String cachedBlockKey;
    @Nullable
    private String cachedDistance;

    public OnLookingAtBlockListener() {
        super("looking_at_block");
    }

    public void onLookAtBlock(@NotNull class_638 level, @NotNull class_3965 hitResult, double distance) {
        class_2338 blockPos = hitResult.method_17777().method_10062();
        class_2680 blockState = level.method_8320(blockPos);
        class_5321 levelKey = level.method_27983();
        if (Objects.equals(this.lastBlockPos, blockPos) && Objects.equals(this.lastBlockState, blockState) && Objects.equals(this.lastLevelKey, levelKey)) {
            return;
        }
        this.lastBlockPos = blockPos;
        this.lastBlockState = blockState;
        this.lastLevelKey = levelKey;
        class_2960 blockKeyLocation = class_7923.field_41175.method_10221((Object)blockState.method_26204());
        this.cachedBlockKey = blockKeyLocation != null ? blockKeyLocation.toString() : null;
        this.cachedDistance = Double.toString(distance);
        this.notifyAllInstances();
    }

    public void onStopLooking() {
        this.lastBlockPos = null;
        this.lastBlockState = null;
        this.lastLevelKey = null;
        this.cachedBlockKey = null;
        this.cachedDistance = null;
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("block_key", () -> this.cachedBlockKey != null ? this.cachedBlockKey : "ERROR"));
        list.add(new AbstractListener.CustomVariable("distance", () -> this.cachedDistance != null ? this.cachedDistance : "0"));
    }

    @Override
    @NotNull
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)"fancymenu.listeners.on_looking_at_block");
    }

    @Override
    @NotNull
    public List<class_2561> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_looking_at_block.desc", new String[0]));
    }
}

