/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.advanced;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1074;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MathSignPlaceholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();

    public MathSignPlaceholder() {
        super("math_sign");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String num = dps.values.get("num");
        if (num != null) {
            try {
                if (MathUtils.isDouble((String)num)) {
                    double numD = Double.parseDouble(num);
                    if (numD > 0.0) {
                        return "1";
                    }
                    if (numD < 0.0) {
                        return "-1";
                    }
                    return "0";
                }
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to parse 'Sign (Math)' placeholder: " + dps.placeholderString, (Throwable)ex);
            }
        }
        LOGGER.error("[FANCYMENU] Failed to parse 'Sign (Math)' placeholder: " + dps.placeholderString);
        return null;
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("num");
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"fancymenu.placeholders.math_sign", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.math_sign.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662((String)"fancymenu.requirements.categories.advanced", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("num", "-3.14");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

