/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mixin.mixins.common.client;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.WelcomeScreen;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiHandler;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.listener.listeners.Listeners;
import de.keksuccino.fancymenu.customization.listener.listeners.helpers.WorldSessionTracker;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.events.screen.CloseScreenEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenCompletedEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenStartingEvent;
import de.keksuccino.fancymenu.events.screen.OpenScreenEvent;
import de.keksuccino.fancymenu.events.screen.OpenScreenPostInitEvent;
import de.keksuccino.fancymenu.events.screen.ScreenTickEvent;
import de.keksuccino.fancymenu.events.ticking.ClientTickEvent;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.mcef.BrowserHandler;
import de.keksuccino.fancymenu.util.mcef.MCEFUtil;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.scrollnormalizer.ScrollScreenNormalizer;
import de.keksuccino.fancymenu.util.resource.ResourceHandlers;
import de.keksuccino.fancymenu.util.resource.preload.ResourcePreLoader;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.fancymenu.util.window.WindowHandler;
import java.net.SocketAddress;
import java.nio.file.Path;
import net.minecraft.class_2535;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_3283;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_3695;
import net.minecraft.class_4071;
import net.minecraft.class_4080;
import net.minecraft.class_418;
import net.minecraft.class_434;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5218;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_642;
import net.minecraft.class_6904;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_310.class})
public class MixinMinecraft {
    @Unique
    private static final String DUMMY_RESOURCE_RELOAD_LISTENER_RETURN_VALUE_FANCYMENU = "PREPARE RETURN VALUE";
    @Unique
    private static final Logger LOGGER_FANCYMENU = LogManager.getLogger();
    @Unique
    private static boolean reloadListenerRegisteredFancyMenu = false;
    @Unique
    private boolean lateClientInitDoneFancyMenu = false;
    @Unique
    private class_437 lastScreen_FancyMenu = null;
    @Unique
    private static final String UNKNOWN_SERVER_IP_FANCYMENU = "ERROR";
    @Unique
    private boolean hasActiveServerConnection_FancyMenu;
    @Unique
    private boolean pendingServerJoinEvent_FancyMenu;
    @Unique
    @Nullable
    private String lastServerIp_FancyMenu;
    @Unique
    private boolean quitListenerFired_FancyMenu;
    @Shadow
    @Nullable
    public class_437 field_1755;
    @Shadow
    @Nullable
    public class_638 field_1687;
    @Shadow
    @Nullable
    public class_746 field_1724;

    @Inject(method={"stop"}, at={@At(value="HEAD")})
    private void before_stop_FancyMenu(CallbackInfo info) {
        if (!this.quitListenerFired_FancyMenu) {
            this.quitListenerFired_FancyMenu = true;
            Listeners.ON_QUIT_MINECRAFT.onQuitMinecraft();
        }
    }

    @Inject(method={"doWorldLoad(Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lnet/minecraft/server/packs/repository/PackRepository;Lnet/minecraft/server/WorldStem;Z)V"}, at={@At(value="HEAD")})
    private void before_doWorldLoad_FancyMenu(class_32.class_5143 levelStorage, class_3283 packRepository, class_6904 worldStem, boolean newWorld, CallbackInfo info) {
        try {
            if (levelStorage != null && worldStem != null) {
                Path savePath = levelStorage.method_27010(class_5218.field_24188).toAbsolutePath();
                String iconPath = levelStorage.method_27014().map(path -> path.toAbsolutePath().toString()).orElse(null);
                String worldName = worldStem.comp_359().method_150();
                WorldSessionTracker.prepareSession(worldName, savePath.toString(), iconPath, newWorld);
            } else {
                WorldSessionTracker.clearSession();
            }
        }
        catch (Exception ex) {
            LOGGER_FANCYMENU.error("[FANCYMENU] Failed to prepare world session data!", (Throwable)ex);
            WorldSessionTracker.clearSession();
        }
    }

    @Inject(method={"setOverlay"}, at={@At(value="HEAD")})
    private void beforeSetOverlayFancyMenu(class_4071 overlay, CallbackInfo info) {
        if (!this.lateClientInitDoneFancyMenu) {
            this.lateClientInitDoneFancyMenu = true;
            FancyMenu.lateClientInit();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void beforeGameTickFancyMenu(CallbackInfo info) {
        if (this.pendingServerJoinEvent_FancyMenu && this.field_1724 != null) {
            this.fireServerJoined_FancyMenu();
        }
        if (MCEFUtil.isMCEFLoaded()) {
            BrowserHandler.tick();
        }
        for (Runnable r : MainThreadTaskExecutor.getAndClearQueue(MainThreadTaskExecutor.ExecuteTiming.PRE_CLIENT_TICK)) {
            try {
                r.run();
            }
            catch (Exception e) {
                LOGGER_FANCYMENU.error("[FANCYMENU] Error while executing PRE_CLIENT_TICK MainThread task!", (Throwable)e);
            }
        }
        EventHandler.INSTANCE.postEvent(new ClientTickEvent.Pre());
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void afterGameTickFancyMenu(CallbackInfo info) {
        EventHandler.INSTANCE.postEvent(new ClientTickEvent.Post());
        for (Runnable r : MainThreadTaskExecutor.getAndClearQueue(MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK)) {
            try {
                r.run();
            }
            catch (Exception e) {
                LOGGER_FANCYMENU.error("[FANCYMENU] Error while executing POST_CLIENT_TICK MainThread task!", (Throwable)e);
            }
        }
    }

    @Inject(method={"setLevel"}, at={@At(value="TAIL")})
    private void afterSetLevelFancyMenu(class_638 clientLevel, class_434.class_9678 reason, CallbackInfo info) {
        String serverIp;
        class_310 self = (class_310)this;
        if (clientLevel == null) {
            return;
        }
        if (self.method_1542()) {
            return;
        }
        if (this.hasActiveServerConnection_FancyMenu || this.pendingServerJoinEvent_FancyMenu) {
            return;
        }
        this.lastServerIp_FancyMenu = serverIp = this.fetchCurrentServerIp_FancyMenu();
        if (this.field_1724 != null) {
            this.fireServerJoined_FancyMenu();
        } else {
            this.pendingServerJoinEvent_FancyMenu = true;
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;wrapScreenError(Ljava/lang/Runnable;Ljava/lang/String;Ljava/lang/String;)V")})
    private void beforeScreenTickFancyMenu(CallbackInfo info) {
        if (this.field_1755 == null) {
            return;
        }
        EventHandler.INSTANCE.postEvent(new ScreenTickEvent.Pre(this.field_1755));
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;wrapScreenError(Ljava/lang/Runnable;Ljava/lang/String;Ljava/lang/String;)V", shift=At.Shift.AFTER)})
    private void afterScreenTickFancyMenu(CallbackInfo info) {
        if (this.field_1755 == null) {
            return;
        }
        EventHandler.INSTANCE.postEvent(new ScreenTickEvent.Post(this.field_1755));
    }

    @Inject(at={@At(value="HEAD")}, method={"createTitle"}, cancellable=true)
    private void changeWindowTitleFancyMenu(CallbackInfoReturnable<String> info) {
        String title = WindowHandler.getCustomWindowTitle();
        if (title != null) {
            info.setReturnValue((Object)title);
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="HEAD")}, cancellable=true)
    private void before_setScreen_FancyMenu(class_437 screen, CallbackInfo info) {
        LayoutEditorScreen e;
        if (screen == null && this.field_1687 == null) {
            screen = new class_442();
        } else if (screen == null && this.field_1724 != null && this.field_1724.method_29504() && this.field_1724.method_22419()) {
            screen = new class_418(null, this.field_1687.method_28104().method_152());
        }
        class_437 finalScreen = screen;
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof LayoutEditorScreen) {
            e = (LayoutEditorScreen)class_4372;
            if (!(screen instanceof LayoutEditorScreen)) {
                e.layout.menuBackgrounds.forEach(menuBackground -> {
                    menuBackground.onCloseScreen(e, finalScreen);
                    menuBackground.onDisableOrRemove();
                });
                e.getAllElements().forEach(element -> {
                    element.element.onCloseScreen(e, finalScreen);
                    element.element.onDestroyElement();
                });
            }
        }
        if (screen instanceof LayoutEditorScreen) {
            e = (LayoutEditorScreen)screen;
            e.justOpened = true;
        }
        this.lastScreen_FancyMenu = this.field_1755;
        RenderingUtils.resetGuiScale();
        if (FancyMenu.getOptions().showWelcomeScreen.getValue().booleanValue() && screen instanceof class_442) {
            info.cancel();
            class_310.method_1551().method_1507((class_437)new WelcomeScreen(screen));
            return;
        }
        class_437 overrideWith = CustomGuiHandler.beforeSetScreen(screen);
        if (overrideWith != null) {
            info.cancel();
            class_310.method_1551().method_1507(overrideWith);
            return;
        }
        if (screen != null && screen != this.field_1755) {
            class_437 cachedCurrent = this.field_1755;
            Listeners.ON_OPEN_SCREEN.onScreenOpened(screen);
            if (cachedCurrent != this.field_1755) {
                info.cancel();
            }
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="RETURN")})
    private void after_setScreen_FancyMenu(class_437 screen, CallbackInfo info) {
        String newId;
        String lastId;
        boolean newScreenType = false;
        if (this.lastScreen_FancyMenu == null && this.field_1755 != null) {
            newScreenType = true;
        } else if (this.lastScreen_FancyMenu != null && this.field_1755 == null) {
            newScreenType = true;
        } else if (this.lastScreen_FancyMenu != null && this.field_1755 != null && !(lastId = ScreenIdentifierHandler.getIdentifierOfScreen(this.lastScreen_FancyMenu)).equals(newId = ScreenIdentifierHandler.getIdentifierOfScreen(this.field_1755))) {
            newScreenType = true;
        }
        if (newScreenType) {
            ScreenCustomization.onSwitchingToNewScreenType(this.field_1755, this.lastScreen_FancyMenu);
        }
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screens/Screen;Z)V"}, at={@At(value="HEAD")})
    private void beforeDisconnectFancyMenu(class_437 screen, boolean keepDownloadedResourcePacks, CallbackInfo info) {
        this.fireServerLeft_FancyMenu();
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screens/Screen;Z)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;level:Lnet/minecraft/client/multiplayer/ClientLevel;", opcode=181, ordinal=0, shift=At.Shift.BEFORE)})
    private void beforeLevelClearedWorldLeftFancyMenu(class_437 screen, boolean keepDownloadedResourcePacks, CallbackInfo info) {
        WorldSessionTracker.handleWorldLeft((class_310)this);
    }

    @Inject(method={"clearClientLevel"}, at={@At(value="HEAD")})
    private void beforeClearClientLevelFancyMenu(class_437 nextScreen, CallbackInfo info) {
        WorldSessionTracker.captureSnapshot((class_310)this);
        this.fireServerLeft_FancyMenu();
        WorldSessionTracker.handleWorldLeft((class_310)this);
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/BufferUploader;reset()V", shift=At.Shift.AFTER)})
    private void beforeInitCurrentScreenFancyMenu(class_437 screen, CallbackInfo info) {
        if (screen != null) {
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenStartingEvent(screen, InitOrResizeScreenEvent.InitializationPhase.INIT));
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Pre(screen, InitOrResizeScreenEvent.InitializationPhase.INIT));
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;updateTitle()V")})
    private void afterInitCurrentScreenFancyMenu(class_437 screen, CallbackInfo info) {
        if (screen != null) {
            ScrollScreenNormalizer.normalizeScrollableScreen(screen);
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Post(screen, InitOrResizeScreenEvent.InitializationPhase.INIT));
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenCompletedEvent(screen, InitOrResizeScreenEvent.InitializationPhase.INIT));
            EventHandler.INSTANCE.postEvent(new OpenScreenPostInitEvent(screen));
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;removed()V")})
    private void beforeScreenRemovedFancyMenu(class_437 screen, CallbackInfo info) {
        if (this.field_1755 == null) {
            return;
        }
        EventHandler.INSTANCE.postEvent(new CloseScreenEvent(this.field_1755, screen));
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;removed()V", shift=At.Shift.AFTER)})
    private void afterScreenRemovedFancyMenu(class_437 screen, CallbackInfo info) {
        if (this.lastScreen_FancyMenu != null) {
            Listeners.ON_CLOSE_SCREEN.onScreenClosed(this.lastScreen_FancyMenu);
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;added()V")})
    private void beforeScreenAddedFancyMenu(class_437 screen, CallbackInfo info) {
        if (this.field_1755 == null) {
            return;
        }
        EventHandler.INSTANCE.postEvent(new OpenScreenEvent(this.field_1755));
    }

    @Inject(method={"resizeDisplay"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/Window;setGuiScale(D)V", shift=At.Shift.AFTER)})
    private void beforeResizeCurrentScreenFancyMenu(CallbackInfo info) {
        if (this.field_1755 != null) {
            RenderingUtils.resetGuiScale();
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenStartingEvent(this.field_1755, InitOrResizeScreenEvent.InitializationPhase.RESIZE));
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Pre(this.field_1755, InitOrResizeScreenEvent.InitializationPhase.RESIZE));
        }
    }

    @Inject(method={"resizeDisplay"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;getMainRenderTarget()Lcom/mojang/blaze3d/pipeline/RenderTarget;")})
    private void afterResizeCurrentScreenFancyMenu(CallbackInfo info) {
        if (this.field_1755 != null) {
            ScrollScreenNormalizer.normalizeScrollableScreen(this.field_1755);
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Post(this.field_1755, InitOrResizeScreenEvent.InitializationPhase.RESIZE));
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenCompletedEvent(this.field_1755, InitOrResizeScreenEvent.InitializationPhase.RESIZE));
        }
    }

    @Inject(method={"resizeDisplay"}, at={@At(value="HEAD")})
    private void registerResourceReloadListenerInResizeDisplayFancyMenu(CallbackInfo info) {
        if (!reloadListenerRegisteredFancyMenu) {
            reloadListenerRegisteredFancyMenu = true;
            class_310 mc = (class_310)this;
            LOGGER_FANCYMENU.info("[FANCYMENU] Registering resource reload listener..");
            class_3300 class_33002 = mc.method_1478();
            if (class_33002 instanceof class_3304) {
                class_3304 r = (class_3304)class_33002;
                r.method_14477((class_3302)new class_4080<String>(this){

                    @NotNull
                    protected String prepare(@NotNull class_3300 var1, @NotNull class_3695 var2) {
                        return MixinMinecraft.DUMMY_RESOURCE_RELOAD_LISTENER_RETURN_VALUE_FANCYMENU;
                    }

                    protected void apply(@NotNull String prepareReturnValue, @NotNull class_3300 var2, @NotNull class_3695 var3) {
                        ResourceHandlers.reloadAll();
                        ResourcePreLoader.preLoadAll(120000L);
                    }
                });
            }
        }
    }

    @Unique
    private void fireServerLeft_FancyMenu() {
        if (!this.hasActiveServerConnection_FancyMenu) {
            this.pendingServerJoinEvent_FancyMenu = false;
            this.lastServerIp_FancyMenu = null;
            return;
        }
        String serverIp = this.lastServerIp_FancyMenu != null && !this.lastServerIp_FancyMenu.isBlank() ? this.lastServerIp_FancyMenu : UNKNOWN_SERVER_IP_FANCYMENU;
        Listeners.ON_SERVER_LEFT.onServerLeft(serverIp);
        this.hasActiveServerConnection_FancyMenu = false;
        this.pendingServerJoinEvent_FancyMenu = false;
        this.lastServerIp_FancyMenu = null;
    }

    @Unique
    private void fireServerJoined_FancyMenu() {
        if (this.hasActiveServerConnection_FancyMenu) {
            return;
        }
        if (this.lastServerIp_FancyMenu == null || this.lastServerIp_FancyMenu.isBlank() || UNKNOWN_SERVER_IP_FANCYMENU.equals(this.lastServerIp_FancyMenu)) {
            this.lastServerIp_FancyMenu = this.fetchCurrentServerIp_FancyMenu();
        }
        String serverIp = this.lastServerIp_FancyMenu != null && !this.lastServerIp_FancyMenu.isBlank() ? this.lastServerIp_FancyMenu : UNKNOWN_SERVER_IP_FANCYMENU;
        this.pendingServerJoinEvent_FancyMenu = false;
        this.hasActiveServerConnection_FancyMenu = true;
        Listeners.ON_SERVER_JOINED.onServerJoined(serverIp);
    }

    @Unique
    private String fetchCurrentServerIp_FancyMenu() {
        String resolved;
        SocketAddress address;
        class_2535 connection;
        class_310 self = (class_310)this;
        class_642 serverData = self.method_1558();
        if (serverData != null && serverData.field_3761 != null && !serverData.field_3761.isBlank()) {
            return serverData.field_3761;
        }
        class_634 listener = self.method_1562();
        if (listener != null && (connection = listener.method_48296()) != null && (address = connection.method_10755()) != null && (resolved = address.toString()) != null && !(resolved = resolved.trim()).isEmpty()) {
            if (resolved.startsWith("/")) {
                resolved = resolved.substring(1);
            }
            if (!resolved.isEmpty()) {
                return resolved;
            }
        }
        return UNKNOWN_SERVER_IP_FANCYMENU;
    }
}

