/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util;

public class OsUtils {
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();

    private OsUtils() {
        throw new UnsupportedOperationException("Utility class should not be instantiated");
    }

    public static boolean isWindows() {
        return OS_NAME.contains("win");
    }

    public static boolean isLinux() {
        return OS_NAME.contains("linux") || OS_NAME.contains("unix") || OS_NAME.contains("nix");
    }

    public static boolean isMacOS() {
        return OS_NAME.contains("mac") || OS_NAME.contains("darwin");
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static OsType getOsType() {
        if (OsUtils.isWindows()) {
            return OsType.WINDOWS;
        }
        if (OsUtils.isLinux()) {
            return OsType.LINUX;
        }
        if (OsUtils.isMacOS()) {
            return OsType.MACOS;
        }
        return OsType.UNKNOWN;
    }

    public static enum OsType {
        WINDOWS("Windows"),
        LINUX("Linux"),
        MACOS("macOS"),
        UNKNOWN("Unknown");

        private final String displayName;

        private OsType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

