/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.blur;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.MinecraftResourceReloadObserver;
import java.io.IOException;
import net.minecraft.class_276;
import net.minecraft.class_280;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4573;
import net.minecraft.class_5253;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_6367;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public final class GuiBlurRenderer {
    private static final Logger LOGGER = LogManager.getLogger((String)"FancyMenu-GuiBlur");
    private static final GuiBlurRenderer INSTANCE = new GuiBlurRenderer();
    private class_6367 pingTarget;
    private class_6367 pongTarget;
    private class_280 boxBlurEffect;
    private class_5944 compositeShader;
    private boolean compositeManagedExternally;
    private boolean resourcesFailed;

    private GuiBlurRenderer() {
        MinecraftResourceReloadObserver.addReloadListener(action -> {
            if (action == MinecraftResourceReloadObserver.ReloadAction.STARTING) {
                class_4573 call = this::resetResources;
                if (RenderSystem.isOnRenderThread()) {
                    call.execute();
                } else {
                    RenderSystem.recordRenderCall((class_4573)call);
                }
            }
        });
    }

    public static GuiBlurRenderer getInstance() {
        return INSTANCE;
    }

    public void apply(@NotNull class_332 graphics, float x, float y, float width, float height, int tintArgb, float intensity, float cornerRadiusGui, boolean rounded) {
        if (width <= 0.0f || height <= 0.0f) {
            return;
        }
        graphics.method_51452();
        RenderSystem.assertOnRenderThread();
        class_310 minecraft = class_310.method_1551();
        class_276 mainTarget = minecraft.method_1522();
        if (mainTarget == null) {
            this.fallbackFill(graphics, x, y, width, height, tintArgb);
            return;
        }
        if (!this.ensureResources(minecraft)) {
            this.fallbackFill(graphics, x, y, width, height, tintArgb);
            return;
        }
        double guiScale = minecraft.method_22683().method_4495();
        int windowWidth = mainTarget.field_1480;
        int windowHeight = mainTarget.field_1477;
        int areaWidthPx = Math.max(1, class_3532.method_15384((double)((double)width * guiScale)));
        int areaHeightPx = Math.max(1, class_3532.method_15384((double)((double)height * guiScale)));
        int areaLeftPx = class_3532.method_15357((double)((double)x * guiScale));
        int areaTopPx = class_3532.method_15357((double)((double)y * guiScale));
        int areaRightPx = areaLeftPx + areaWidthPx;
        int areaBottomPx = windowHeight - (areaTopPx + areaHeightPx);
        if (areaRightPx <= 0 || areaLeftPx >= windowWidth || areaBottomPx >= windowHeight || areaBottomPx + areaHeightPx <= 0) {
            return;
        }
        float radius = intensity <= 1.0f ? intensity * 10.0f : intensity;
        if ((radius = class_3532.method_15363((float)radius, (float)0.0f, (float)10.0f)) < 0.05f) {
            this.fallbackFill(graphics, x, y, width, height, tintArgb);
            return;
        }
        int padding = Math.max(2, class_3532.method_15386((float)radius) + 2);
        int copyLeft = class_3532.method_15340((int)(areaLeftPx - padding), (int)0, (int)windowWidth);
        int copyRight = class_3532.method_15340((int)(areaRightPx + padding), (int)0, (int)windowWidth);
        int copyBottom = class_3532.method_15340((int)(areaBottomPx - padding), (int)0, (int)windowHeight);
        int copyTop = class_3532.method_15340((int)(areaBottomPx + areaHeightPx + padding), (int)0, (int)windowHeight);
        int copyWidth = Math.max(1, copyRight - copyLeft);
        int copyHeight = Math.max(1, copyTop - copyBottom);
        class_6367 horizontalTarget = this.ensureTarget(copyWidth, copyHeight, true);
        class_6367 verticalTarget = this.ensureTarget(copyWidth, copyHeight, false);
        if (horizontalTarget == null || verticalTarget == null) {
            this.fallbackFill(graphics, x, y, width, height, tintArgb);
            return;
        }
        this.blitRegion(mainTarget, horizontalTarget, copyLeft, copyBottom, copyRight, copyTop);
        class_6367 blurredTarget = this.runBlurPasses(minecraft, horizontalTarget, verticalTarget, radius);
        this.restoreMainTarget(mainTarget);
        if (blurredTarget == null) {
            this.fallbackFill(graphics, x, y, width, height, tintArgb);
            return;
        }
        float uMin = (float)class_3532.method_15340((int)(areaLeftPx - copyLeft), (int)0, (int)copyWidth) / (float)copyWidth;
        float uMax = (float)class_3532.method_15340((int)(areaRightPx - copyLeft), (int)0, (int)copyWidth) / (float)copyWidth;
        float vMin = (float)class_3532.method_15340((int)(areaBottomPx - copyBottom), (int)0, (int)copyHeight) / (float)copyHeight;
        float vMax = (float)class_3532.method_15340((int)(areaBottomPx + areaHeightPx - copyBottom), (int)0, (int)copyHeight) / (float)copyHeight;
        float tintR = (float)class_5253.class_5254.method_27765((int)tintArgb) / 255.0f;
        float tintG = (float)class_5253.class_5254.method_27766((int)tintArgb) / 255.0f;
        float tintB = (float)class_5253.class_5254.method_27767((int)tintArgb) / 255.0f;
        float tintA = (float)class_5253.class_5254.method_27762((int)tintArgb) / 255.0f;
        float cornerRadiusPx = rounded ? cornerRadiusGui * (float)guiScale : 0.0f;
        float maxRadiusPx = (float)Math.min(areaWidthPx, areaHeightPx) * 0.5f;
        cornerRadiusPx = rounded ? class_3532.method_15363((float)cornerRadiusPx, (float)0.0f, (float)maxRadiusPx) : 0.0f;
        boolean useRoundedOutline = rounded && cornerRadiusPx > 0.0f;
        float smoothRadiusPx = useRoundedOutline ? Math.max(1.0f, (float)guiScale * 0.75f) : 0.0f;
        this.renderCompositeQuad(graphics, blurredTarget, x, y, width, height, areaLeftPx, areaBottomPx, areaWidthPx, areaHeightPx, uMin, vMin, uMax, vMax, tintR, tintG, tintB, tintA, cornerRadiusPx, smoothRadiusPx, useRoundedOutline, tintArgb);
    }

    private void fallbackFill(class_332 graphics, float x, float y, float width, float height, int tintArgb) {
        int minX = class_3532.method_15375((float)x);
        int minY = class_3532.method_15375((float)y);
        int maxX = class_3532.method_15375((float)(x + width));
        int maxY = class_3532.method_15375((float)(y + height));
        graphics.method_25294(minX, minY, maxX, maxY, tintArgb);
        LOGGER.warn("[FANCYMENU] Using fallback fill for blur area!");
    }

    private boolean ensureResources(class_310 minecraft) {
        if (this.resourcesFailed) {
            return false;
        }
        class_3300 provider = minecraft.method_1478();
        try {
            if (this.boxBlurEffect == null) {
                this.boxBlurEffect = new class_280((class_5912)provider, "box_blur");
            }
            if (this.compositeShader == null) {
                this.compositeShader = new class_5944((class_5912)provider, "fancymenu_gui_blur_composite", class_290.field_1585);
                this.compositeManagedExternally = false;
            }
        }
        catch (IOException exception) {
            LOGGER.error("Failed to initialize GUI blur shader resources", (Throwable)exception);
            this.resetResources();
            this.resourcesFailed = true;
            return false;
        }
        this.resourcesFailed = false;
        return true;
    }

    @Nullable
    private class_6367 ensureTarget(int width, int height, boolean primary) {
        class_6367 target = primary ? this.pingTarget : this.pongTarget;
        try {
            if (target == null) {
                target = new class_6367(width, height, false, class_310.field_1703);
                target.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
                target.method_58226(9729);
                if (primary) {
                    this.pingTarget = target;
                } else {
                    this.pongTarget = target;
                }
            } else if (target.field_1482 != width || target.field_1481 != height) {
                target.method_1234(width, height, class_310.field_1703);
                target.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
                target.method_58226(9729);
            }
            return target;
        }
        catch (RuntimeException error) {
            LOGGER.error("Unable to allocate blur framebuffer of size {}x{}", (Object)width, (Object)height, (Object)error);
            if (primary) {
                this.pingTarget = null;
            } else {
                this.pongTarget = null;
            }
            this.resourcesFailed = true;
            return null;
        }
    }

    private void blitRegion(class_276 mainTarget, class_6367 destination, int srcLeft, int srcBottom, int srcRight, int srcTop) {
        GlStateManager._glBindFramebuffer((int)36008, (int)mainTarget.field_1476);
        GlStateManager._glBindFramebuffer((int)36009, (int)destination.field_1476);
        GlStateManager._glBlitFrameBuffer((int)srcLeft, (int)srcBottom, (int)srcRight, (int)srcTop, (int)0, (int)0, (int)destination.field_1482, (int)destination.field_1481, (int)16384, (int)9729);
        GlStateManager._glBindFramebuffer((int)36008, (int)0);
        GlStateManager._glBindFramebuffer((int)36009, (int)0);
    }

    private void restoreMainTarget(class_276 mainTarget) {
        mainTarget.method_1235(false);
        RenderSystem.viewport((int)0, (int)0, (int)mainTarget.field_1480, (int)mainTarget.field_1477);
        RenderSystem.depthFunc((int)515);
    }

    @Nullable
    private class_6367 runBlurPasses(class_310 minecraft, class_6367 horizontalInput, class_6367 verticalInput, float radius) {
        if (this.boxBlurEffect == null) {
            return null;
        }
        this.configureBlurEffect(minecraft, horizontalInput, verticalInput, new Matrix4f().setOrtho(0.0f, (float)verticalInput.field_1482, 0.0f, (float)verticalInput.field_1481, -1.0f, 1.0f), radius, 1.0f, 0.0f);
        verticalInput.method_1230(false);
        verticalInput.method_1235(false);
        RenderSystem.viewport((int)0, (int)0, (int)verticalInput.field_1482, (int)verticalInput.field_1481);
        RenderSystem.depthFunc((int)519);
        this.boxBlurEffect.method_1277();
        this.drawFullscreenQuad(verticalInput.field_1482, verticalInput.field_1481);
        this.boxBlurEffect.method_1273();
        verticalInput.method_1240();
        this.configureBlurEffect(minecraft, verticalInput, horizontalInput, new Matrix4f().setOrtho(0.0f, (float)horizontalInput.field_1482, 0.0f, (float)horizontalInput.field_1481, -1.0f, 1.0f), radius, 0.0f, 1.0f);
        horizontalInput.method_1230(false);
        horizontalInput.method_1235(false);
        RenderSystem.viewport((int)0, (int)0, (int)horizontalInput.field_1482, (int)horizontalInput.field_1481);
        RenderSystem.depthFunc((int)519);
        this.boxBlurEffect.method_1277();
        this.drawFullscreenQuad(horizontalInput.field_1482, horizontalInput.field_1481);
        this.boxBlurEffect.method_1273();
        horizontalInput.method_1240();
        verticalInput.method_1242();
        RenderSystem.depthFunc((int)515);
        return horizontalInput;
    }

    private void configureBlurEffect(class_310 minecraft, class_6367 input, class_6367 output, Matrix4f projection, float radius, float dirX, float dirY) {
        if (this.boxBlurEffect == null) {
            return;
        }
        this.boxBlurEffect.method_1269("DiffuseSampler", () -> ((class_6367)input).method_30277());
        this.boxBlurEffect.method_1275("ProjMat").method_1250(projection);
        this.boxBlurEffect.method_1275("InSize").method_1255((float)input.field_1482, (float)input.field_1481);
        this.boxBlurEffect.method_1275("OutSize").method_1255((float)output.field_1482, (float)output.field_1481);
        this.boxBlurEffect.method_1275("BlurDir").method_1255(dirX, dirY);
        this.boxBlurEffect.method_1275("Radius").method_1251(radius);
        this.boxBlurEffect.method_1275("RadiusMultiplier").method_1251(1.0f);
        this.boxBlurEffect.method_1275("Time").method_1251(0.0f);
        this.boxBlurEffect.method_1275("ScreenSize").method_1255((float)minecraft.method_22683().method_4489(), (float)minecraft.method_22683().method_4506());
    }

    private void drawFullscreenQuad(int width, int height) {
        class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        builder.method_22912(0.0f, 0.0f, 0.0f);
        builder.method_22912((float)width, 0.0f, 0.0f);
        builder.method_22912((float)width, (float)height, 0.0f);
        builder.method_22912(0.0f, (float)height, 0.0f);
        class_9801 meshData = builder.method_60800();
        class_286.method_43437((class_9801)meshData);
        meshData.close();
    }

    private void renderCompositeQuad(class_332 graphics, class_6367 texture, float x, float y, float width, float height, int areaLeftPx, int areaBottomPx, int areaWidthPx, int areaHeightPx, float uMin, float vMin, float uMax, float vMax, float tintR, float tintG, float tintB, float tintA, float cornerRadiusPx, float smoothRadiusPx, boolean useRounded, int fallbackTint) {
        if (this.compositeShader == null) {
            this.fallbackFill(graphics, x, y, width, height, fallbackTint);
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(() -> this.compositeShader);
        this.compositeShader.method_34583("BlurSampler", (Object)texture);
        LOGGER.info("Using blur sampler texture {} ({}x{})", (Object)texture.method_30277(), (Object)texture.field_1482, (Object)texture.field_1481);
        Matrix4f poseMatrix = graphics.method_51448().method_23760().method_23761();
        this.compositeShader.method_35785("ModelViewMat").method_1250(poseMatrix);
        this.compositeShader.method_35785("ProjMat").method_1250(RenderSystem.getProjectionMatrix());
        this.compositeShader.method_35785("ColorTint").method_1254(tintR, tintG, tintB, tintA);
        this.compositeShader.method_35785("UVMin").method_1255(uMin, vMin);
        this.compositeShader.method_35785("UVMax").method_1255(uMax, vMax);
        this.compositeShader.method_35785("AreaOrigin").method_1255((float)areaLeftPx, (float)areaBottomPx);
        this.compositeShader.method_35785("AreaSize").method_1255((float)areaWidthPx, (float)areaHeightPx);
        this.compositeShader.method_35785("CornerRadius").method_1251(cornerRadiusPx);
        this.compositeShader.method_35785("SmoothRadius").method_1251(smoothRadiusPx);
        this.compositeShader.method_35785("Rounded").method_35649(useRounded ? 1 : 0);
        this.compositeShader.method_34586();
        float minX = x;
        float minY = y;
        float maxX = x + width;
        float maxY = y + height;
        float z = 0.0f;
        class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        builder.method_22918(poseMatrix, minX, maxY, z).method_22913(0.0f, 1.0f);
        builder.method_22918(poseMatrix, maxX, maxY, z).method_22913(1.0f, 1.0f);
        builder.method_22918(poseMatrix, maxX, minY, z).method_22913(1.0f, 0.0f);
        builder.method_22918(poseMatrix, minX, minY, z).method_22913(0.0f, 0.0f);
        class_9801 meshData = builder.method_60800();
        class_286.method_43437((class_9801)meshData);
        meshData.close();
        this.compositeShader.method_34585();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
    }

    public void resetResources() {
        RenderSystem.assertOnRenderThread();
        if (this.boxBlurEffect != null) {
            this.boxBlurEffect.close();
            this.boxBlurEffect = null;
        }
        if (this.pingTarget != null) {
            this.pingTarget.method_1238();
            this.pingTarget = null;
        }
        if (this.pongTarget != null) {
            this.pongTarget.method_1238();
            this.pongTarget = null;
        }
        if (this.compositeShader != null) {
            if (!this.compositeManagedExternally) {
                this.compositeShader.close();
            }
            this.compositeShader = null;
            this.compositeManagedExternally = false;
        }
        this.resourcesFailed = false;
    }

    public void setCompositeShader(@NotNull class_5944 shader, boolean managedExternally) {
        class_4573 apply = () -> {
            if (this.compositeShader != null && !this.compositeManagedExternally) {
                this.compositeShader.close();
            }
            this.compositeShader = shader;
            this.compositeManagedExternally = managedExternally;
            this.resourcesFailed = false;
        };
        if (RenderSystem.isOnRenderThread()) {
            apply.execute();
        } else {
            RenderSystem.recordRenderCall((class_4573)apply);
        }
    }
}

