/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.animation;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerElement;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerHandler;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerStateController;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisableElementAnimatorAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();

    public DisableElementAnimatorAction() {
        super("disable_element_animator");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        try {
            AbstractElement element;
            if (value == null || value.isEmpty()) {
                return;
            }
            AnimationControllerStateController.setPlaying(value, false);
            ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getActiveLayer();
            if (layer != null && (element = layer.getElementByInstanceIdentifier(value)) instanceof AnimationControllerElement) {
                AnimationControllerElement controller = (AnimationControllerElement)element;
                AnimationControllerHandler.resetController(controller);
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to execute DisableElementAnimatorAction!", (Throwable)ex);
        }
    }

    @Override
    @NotNull
    public Component getActionDisplayName() {
        return Component.m_237115_((String)"fancymenu.actions.disable_element_animator");
    }

    @Override
    @NotNull
    public Component[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.disable_element_animator.desc", new String[0]);
    }

    @Override
    public Component getValueDisplayName() {
        return Component.m_237115_((String)"fancymenu.actions.disable_element_animator.value.desc");
    }

    @Override
    public String getValueExample() {
        return "element_animator_identifier";
    }
}

